'use strict';

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var React = require('react');
var classNames = require('classnames');

var STYLES = require('./STYLES');

var Badge = React.createClass({
    displayName: 'Badge',

    propTypes: {
        style: React.PropTypes.oneOf(STYLES),
        className: React.PropTypes.string,
        children: React.PropTypes.node
    },

    getDefaultProps: function getDefaultProps() {
        return {
            style: STYLES[0]
        };
    },
    render: function render() {
        var style = this.props.style;
        var className = classNames('badge', 'badge-' + style, this.props.className);

        return React.createElement(
            'span',
            { className: className },
            this.props.children
        );
    }
});

/**
 * Create a style for badges
 * @param {String} style
 * @return {React.Component}
 */
function createBadgeStyle(style) {
    return React.createClass({
        displayName: Badge.displayName + style,
        render: function render() {
            return React.createElement(Badge, _extends({}, this.props, { style: style.toLowerCase() }));
        }
    });
}

module.exports = Badge;
module.exports.Info = createBadgeStyle('Info');
module.exports.Danger = createBadgeStyle('Danger');
module.exports.Success = createBadgeStyle('Success');
module.exports.Warning = createBadgeStyle('Warning');
//# sourceMappingURL=data:application/json;base64,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