'use strict';

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

var React = require('react');
var classNames = require('classnames');

var Icon = require('./Icon');
var STYLES = require('./STYLES');
var SIZES = require('./SIZES');

var BUTTONS_STYLES = STYLES.concat(['link', 'marketing-primary', 'secondary', 'count']);

var Button = React.createClass({
    displayName: 'Button',

    propTypes: {
        className: React.PropTypes.string,
        children: React.PropTypes.node,
        type: React.PropTypes.string,
        size: React.PropTypes.oneOf(SIZES),
        style: React.PropTypes.oneOf(BUTTONS_STYLES),
        // Makes a link button
        href: React.PropTypes.string,
        // Form button
        value: React.PropTypes.oneOfType([React.PropTypes.string, React.PropTypes.bool, React.PropTypes.number]),
        name: React.PropTypes.string,
        // For links
        target: React.PropTypes.string,
        filled: React.PropTypes.bool,
        noBorder: React.PropTypes.bool,
        disabled: React.PropTypes.bool,
        active: React.PropTypes.bool,
        block: React.PropTypes.bool,
        dropdownToggle: React.PropTypes.bool,
        onClick: React.PropTypes.func,
        title: React.PropTypes.string,
        icon: React.PropTypes.string
    },

    getInitialState: function getInitialState() {
        return {
            clicked: false
        };
    },
    getDefaultProps: function getDefaultProps() {
        return {
            style: 'default',
            size: 'md',
            type: 'button',
            filled: false,
            disabled: false,
            active: false
        };
    },
    onClick: function onClick(e) {
        var _this = this;

        var clicked = this.state.clicked;


        if (this.props.onClick && !clicked) {
            this.props.onClick(e);
        }

        if (!this.isFormButton()) {
            return;
        } else if (clicked) {
            return this.setState({
                clicked: false
            });
        }

        // Add this submitting button's value to the form as hidden
        // input. Only after that do the click.
        // This fixes issues with PJAX[1] in Firefox[2]
        // [1]: https://github.com/defunkt/jquery-pjax/pull/295
        // [2]: http://stackoverflow.com/questions/38277900/formdata-object-does-not-add-submit-type-inputs-from-form-while-on-firefox
        e.preventDefault();
        this.setState({
            clicked: true
        }, function () {
            _this.refs.button.click();
        });
    },
    isFormButton: function isFormButton() {
        var _props = this.props,
            type = _props.type,
            name = _props.name;

        return type === 'submit' && name;
    },
    render: function render() {
        var clicked = this.state.clicked;

        var _props2 = this.props,
            title = _props2.title,
            icon = _props2.icon,
            filled = _props2.filled,
            block = _props2.block,
            noBorder = _props2.noBorder,
            active = _props2.active,
            dropdownToggle = _props2.dropdownToggle,
            style = _props2.style,
            size = _props2.size,
            className = _props2.className,
            children = _props2.children,
            name = _props2.name,
            value = _props2.value,
            disabled = _props2.disabled,
            props = _objectWithoutProperties(_props2, ['title', 'icon', 'filled', 'block', 'noBorder', 'active', 'dropdownToggle', 'style', 'size', 'className', 'children', 'name', 'value', 'disabled']);

        var inner = icon ? React.createElement(Icon, { className: icon }) : '';

        props.className = classNames('btn', 'btn-' + style, 'btn-' + size, className, {
            'btn-fill': filled,
            'btn-block': block,
            'btn-noborder': noBorder,
            active: active, disabled: disabled,
            'dropdown-toggle': dropdownToggle,
            'tooltipped': Boolean(title)
        });
        props['aria-label'] = title;
        props.role = 'button';
        props.disabled = disabled;
        props.onClick = this.onClick;

        var input = void 0;

        if (clicked && this.isFormButton()) {
            input = React.createElement('input', { type: 'hidden', name: name, value: value });
        }

        if (props.href) {
            delete props.type;
            return React.createElement(
                'a',
                props,
                inner,
                ' ',
                children
            );
        } else {
            return React.createElement(
                'button',
                _extends({ ref: 'button' }, props),
                inner,
                ' ',
                children,
                input
            );
        }
    }
});

var ButtonGroup = React.createClass({
    displayName: 'ButtonGroup',

    propTypes: {
        className: React.PropTypes.string,
        children: React.PropTypes.node,
        pull: React.PropTypes.string,
        block: React.PropTypes.bool
    },

    render: function render() {
        var _props3 = this.props,
            className = _props3.className,
            pull = _props3.pull,
            children = _props3.children,
            block = _props3.block,
            props = _objectWithoutProperties(_props3, ['className', 'pull', 'children', 'block']);

        className = classNames('btn-group', className, pull ? 'pull-' + pull : '', {
            'btn-group-block': block
        });

        return React.createElement(
            'div',
            _extends({ className: className }, props),
            children
        );
    }
});

var ButtonToolbar = React.createClass({
    displayName: 'ButtonToolbar',

    propTypes: {
        className: React.PropTypes.string,
        children: React.PropTypes.node
    },

    render: function render() {
        var _props4 = this.props,
            className = _props4.className,
            children = _props4.children,
            props = _objectWithoutProperties(_props4, ['className', 'children']);

        return React.createElement(
            'div',
            _extends({ className: 'btn-toolbar ' + (className || '') }, props),
            children
        );
    }
});

var ButtonCaret = React.createClass({
    displayName: 'ButtonCaret',
    render: function render() {
        return React.createElement('span', { className: 'caret' });
    }
});

var ButtonTextExpander = React.createClass({
    displayName: 'ButtonTextExpander',

    propTypes: {
        onClick: React.PropTypes.func
    },

    onClick: function onClick(e) {
        if (this.props.onClick) {
            this.props.onClick();
        }
    },
    render: function render() {
        return React.createElement(
            'span',
            { className: 'hidden-text-expander' },
            React.createElement(
                'button',
                { type: 'button', className: 'ellipsis-expander', onClick: this.onClick },
                '\u2026'
            )
        );
    }
});

module.exports = Button;
module.exports.Group = ButtonGroup;
module.exports.Toolbar = ButtonToolbar;
module.exports.Caret = ButtonCaret;
module.exports.TextExpander = ButtonTextExpander;
module.exports.STYLES = BUTTONS_STYLES;
//# sourceMappingURL=data:application/json;base64,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