'use strict';

var React = require('react');
var classNames = require('classnames');

var OCTICONS = ['alert', 'arrow-down', 'arrow-left', 'arrow-right', 'arrow-small-down', 'arrow-small-left', 'arrow-small-right', 'arrow-small-up', 'arrow-up', 'beaker', 'bell', 'bold', 'book', 'bookmark', 'briefcase', 'broadcast', 'browser', 'bug', 'calendar', 'check', 'checklist', 'chevron-down', 'chevron-left', 'chevron-right', 'chevron-up', 'circle-slash', 'circuit-board', 'clippy', 'clock', 'cloud-download', 'cloud-upload', 'code', 'comment-discussion', 'comment', 'credit-card', 'dash', 'dashboard', 'database', 'desktop-download', 'device-camera-video', 'device-camera', 'device-desktop', 'device-mobile', 'diff-added', 'diff-ignored', 'diff-modified', 'diff-removed', 'diff-renamed', 'diff', 'ellipsis', 'eye', 'file-binary', 'file-code', 'file-directory', 'file-media', 'file-pdf', 'file-submodule', 'file-symlink-directory', 'file-symlink-file', 'file-text', 'file-zip', 'flame', 'fold', 'gear', 'gift', 'gist-secret', 'gist', 'git-branch', 'git-commit', 'git-compare', 'git-merge', 'git-pull-request', 'globe', 'graph', 'heart', 'history', 'home', 'horizontal-rule', 'hubot', 'inbox', 'info', 'issue-closed', 'issue-opened', 'issue-reopened', 'italic', 'jersey', 'key', 'keyboard', 'law', 'light-bulb', 'link-external', 'link', 'list-ordered', 'list-unordered', 'location', 'lock', 'logo-gist', 'logo-github', 'mail-read', 'mail-reply', 'mail', 'mark-github', 'markdown', 'megaphone', 'mention', 'milestone', 'mirror', 'mortar-board', 'mute', 'no-newline', 'octoface', 'organization', 'package', 'paintcan', 'pencil', 'person', 'pin', 'plug', 'plus', 'primitive-dot', 'primitive-square', 'pulse', 'question', 'quote', 'radio-tower', 'repo-clone', 'repo-force-push', 'repo-forked', 'repo-pull', 'repo-push', 'repo', 'rocket', 'rss', 'ruby', 'search', 'server', 'settings', 'shield', 'sign-in', 'sign-out', 'smiley', 'squirrel', 'star', 'stop', 'sync', 'tag', 'tasklist', 'telescope', 'terminal', 'text-size', 'three-bars', 'thumbsdown', 'thumbsup', 'tools', 'trashcan', 'triangle-down', 'triangle-left', 'triangle-right', 'triangle-up', 'unfold', 'unmute', 'verified', 'versions', 'watch', 'x', 'zap'];

/**
 * Render an icon from octicon or font-awesome
 * @type {ReactClass}
 */
var Icon = React.createClass({
    displayName: 'Icon',

    statics: {
        OCTICONS: OCTICONS
    },

    propTypes: {
        // Icon of the icon in the collection
        id: React.PropTypes.string,
        // Type of collection
        type: React.PropTypes.string,
        // Extra className
        className: React.PropTypes.string,
        // Is the icon spinning?
        spin: React.PropTypes.bool
    },

    getDefaultProps: function getDefaultProps() {
        return {
            type: 'octicon',
            spin: false
        };
    },
    render: function render() {
        var _props = this.props,
            type = _props.type,
            id = _props.id,
            className = _props.className,
            spin = _props.spin;


        className = classNames('Icon', type + ' ' + type + '-' + id, className, {
            'icon-spin': spin
        });

        return React.createElement('i', { className: className });
    }
});

module.exports = Icon;
//# sourceMappingURL=data:application/json;base64,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