'use strict';

var React = require('react');
var classNames = require('classnames');

var Table = React.createClass({
    displayName: 'Table',

    propTypes: {
        bordered: React.PropTypes.bool,
        className: React.PropTypes.string,
        children: React.PropTypes.node
    },

    getDefaultProps: function getDefaultProps() {
        return {
            bordered: false,
            className: ''
        };
    },
    render: function render() {
        var className = classNames('table', { 'table-bordered': this.props.bordered }, this.props.className);

        return React.createElement(
            'table',
            { className: className },
            this.props.children
        );
    }
});

/**
 * ExpendableBody creates a <tbody> element displaying only `display` elements by default
 * If the number of elements is larger than the original `display` prop, a `Show More`
 * button is appended as the last row of the <tbody>. Clicking on it will display `step`
 * more elements each time, until every element is renderded.
 *
 * The elements to display are passed through the `data` prop as an array.
 * Each item of the array can either be:
 *     - a value: the default is to render a single cell with the value for this row
 *     - an array of values: the default is to render each value in a cell for this row
 *     - an object
 *
 * To render an object or customize the display of value(s), the `renderRow` prop accepts
 * a function to which is passed the current row item (value, array or object) and the row index.
 * It must return the corresponding row <tr key={index}> element.
 *
 * Finally, the `cols` prop is used to correctly display the `Show More` button in the table when
 * passing an array of objects to `data`.
 *
 * The `center` props allows for centering all values rendered by default.
 */

var ExpendableBody = React.createClass({
    displayName: 'ExpendableBody',

    propTypes: {
        data: React.PropTypes.array.isRequired,
        display: React.PropTypes.number,
        step: React.PropTypes.number,
        cols: React.PropTypes.string,
        renderRow: React.PropTypes.func,
        center: React.PropTypes.bool
    },

    getDefaultProps: function getDefaultProps() {
        return {
            display: 5,
            step: 5,
            cols: 1,
            center: false
        };
    },
    getInitialState: function getInitialState() {
        return {
            limit: this.props.display
        };
    },
    isArray: function isArray(o) {
        return Object.prototype.toString.call(o) == '[object Array]';
    },
    defaultRenderRow: function defaultRenderRow(item, i) {
        var className = classNames({
            'text-center': this.props.center
        });

        // Array of values per row
        if (this.isArray(item)) {
            return React.createElement(
                'tr',
                { key: i },
                item.map(function (value, j) {
                    return React.createElement(
                        'td',
                        { className: className, key: j },
                        value
                    );
                })
            );
        } else {
            // Single value
            return React.createElement(
                'tr',
                { key: i },
                React.createElement(
                    'td',
                    { className: className },
                    item
                )
            );
        }
    },
    showMore: function showMore() {
        var step = this.props.step;
        var limit = this.state.limit;


        this.setState({
            limit: limit + step
        });
    },
    renderShowMore: function renderShowMore() {
        var _props = this.props,
            data = _props.data,
            cols = _props.cols,
            step = _props.step;
        var limit = this.state.limit;

        var length = data.length;

        // Don't display when everything's on the screen
        if (limit >= length) {
            return null;
        }

        // Try to get colSpan from data if array
        if (Boolean(length) && this.isArray(data[0])) {
            cols = data[0].length.toString();
        }

        return React.createElement(
            'tr',
            null,
            React.createElement(
                'td',
                { className: 'text-center', colSpan: cols },
                React.createElement(
                    'div',
                    { className: 'show-more', onClick: this.showMore },
                    'Show ',
                    step,
                    ' more (',
                    length - limit,
                    ')'
                )
            )
        );
    },
    renderRow: function renderRow(item, i) {
        var renderRow = this.props.renderRow || this.defaultRenderRow;
        return renderRow(item, i);
    },
    render: function render() {
        var data = this.props.data;
        var limit = this.state.limit;


        return React.createElement(
            'tbody',
            { className: 'table-body-expendable' },
            data.slice(0, limit).map(this.renderRow, this),
            this.renderShowMore()
        );
    }
});

module.exports = Table;
module.exports.ExpendableBody = ExpendableBody;
//# sourceMappingURL=data:application/json;base64,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