'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
var React = require('/Users/samypesse/Projects/GitBook/styleguide/node_modules/react/react.js');

var Page = require('./components/Page');
var Example = require('./components/Example');
var CodeEditor = require('./components/CodeEditor');

var Panel = require('../src/Panel');
var Modal = require('../src/Modal');
var Button = require('../src/Button');
var Backdrop = require('../src/Backdrop');

var SCOPE = { React: React, Modal: Modal, Button: Button, Backdrop: Backdrop };

var EXAMPLE_IMPORT = 'const Modal = require(\'gitbook-styleguide/lib/Modal\');';

var EXAMPLE_DEFAULT = '<Modal>\n    <Modal.Heading title="Title" />\n    <Modal.Body>\n        Body of the modal\n    </Modal.Body>\n    <Modal.Footer>\n        <Button style="secondary">Cancel</Button>\n        <Button style="primary">Important action</Button>\n    </Modal.Footer>\n</Modal>';

var EXAMPLE_BACKDROP = '\n<Button onClick={event => this.setState({ open: true })}>Open modal</Button>\n{this.state.open ?\n    <Backdrop wrapper={<Modal.Backdrop />} onClose={event => this.setState({ open: false })}>\n        <Modal>\n            <Modal.Heading title="Title" />\n            <Modal.Body>\n                Body of the modal\n            </Modal.Body>\n            <Modal.Footer>\n                <Button style="secondary" onClick={event => this.setState({ open: false })}>Cancel</Button>\n                <Button style="primary">Important action</Button>\n            </Modal.Footer>\n        </Modal>\n    </Backdrop>\n: null}';

exports.default = function () {
    return React.createElement(
        Page,
        { title: 'Modals', active: 'modals' },
        React.createElement(
            Panel,
            null,
            React.createElement(Panel.Heading, { title: 'Modals' }),
            React.createElement(
                Panel.Body,
                null,
                React.createElement(
                    'p',
                    null,
                    'Modals are streamlined, but flexible, dialog prompts with the minimum required functionality and smart defaults.'
                ),
                React.createElement(CodeEditor, { source: EXAMPLE_IMPORT })
            )
        ),
        React.createElement(Example, { title: 'Example', source: EXAMPLE_DEFAULT, scope: SCOPE }),
        React.createElement(Example, { title: 'With a backdrop', source: EXAMPLE_BACKDROP, scope: SCOPE })
    );
};