'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
var React = require('/Users/samypesse/Projects/GitBook/styleguide/node_modules/react/react.js');

var Page = require('./components/Page');
var Example = require('./components/Example');
var CodeEditor = require('./components/CodeEditor');

var Panel = require('../src/Panel');
var Popover = require('../src/Popover');
var Input = require('../src/Input');
var Icon = require('../src/Icon');
var Button = require('../src/Button');

var SCOPE = { React: React, Panel: Panel, Popover: Popover, Button: Button, Input: Input, Icon: Icon };

var EXAMPLE_IMPORT = 'const Popover = require(\'gitbook-styleguide/lib/Popover\');';

var EXAMPLE_DEFAULT = '<Popover>\n    <Popover.Heading title="Hello" />\n    <Popover.Body>\n        Inner body of the popover.\n    </Popover.Body>\n    <Popover.Controls>\n        <Popover.Control active onClick={event => alert(\'Hello\')}>\n            Say Hello\n        </Popover.Control>\n        <Popover.Control onClick={event => alert(\'World\')}>\n            Say World\n        </Popover.Control>\n    </Popover.Controls>\n</Popover>';

var EXAMPLE_WITH_INPUT = '<Popover>\n    <Popover.Heading>\n        <Popover.Title>\n            <Icon id="pencil" /> Edit title\n        </Popover.Title>\n    </Popover.Heading>\n    <Popover.Body>\n        <Input placeholder="Some title" />\n    </Popover.Body>\n</Popover>';

var EXAMPLE_BUTTON = '<Popover.Container>\n    <Button onClick={event => this.setState({ open: !this.state.open })}>\n        Toggle Popover\n    </Button>\n    {this.state.open? (<Popover>\n        <Popover.Heading title="Hello" />\n        <Popover.Body>\n            Inner body of the popover.\n        </Popover.Body>\n    </Popover>) : null}\n</Popover.Container>';

exports.default = function () {
    return React.createElement(
        Page,
        { title: 'Popovers', active: 'popovers' },
        React.createElement(
            Panel,
            null,
            React.createElement(Panel.Heading, { title: 'Popovers' }),
            React.createElement(
                Panel.Body,
                null,
                React.createElement(
                    'p',
                    null,
                    'Add small overlay content, like those found in iOS, to any element for housing secondary information.'
                ),
                React.createElement(CodeEditor, { source: EXAMPLE_IMPORT })
            )
        ),
        React.createElement(Example, { title: 'Example', source: EXAMPLE_DEFAULT, scope: SCOPE }),
        React.createElement(Example, { title: 'With an input', source: EXAMPLE_WITH_INPUT, scope: SCOPE }),
        React.createElement(Example, { title: 'With button and state', source: EXAMPLE_BUTTON, scope: SCOPE })
    );
};