'use strict';

var _from = require('/Users/samypesse/Projects/GitBook/styleguide/node_modules/next/node_modules/babel-runtime/core-js/array/from');

var _from2 = _interopRequireDefault(_from);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var React = require('/Users/samypesse/Projects/GitBook/styleguide/node_modules/react/react.js');
var classNames = require('classnames');

var Pagination = React.createClass({
    displayName: 'Pagination',

    propTypes: {
        // Index of current page
        page: React.PropTypes.number.isRequired,

        // Total count of pages
        pages: React.PropTypes.number.isRequired,

        // Minimum number of pages to list
        pagesToList: React.PropTypes.number,

        // Callback when page changed (optional)
        onChange: React.PropTypes.func,

        // Current uri
        getURL: React.PropTypes.func
    },

    getDefaultProps: function getDefaultProps() {
        return {
            getURL: function getURL(page) {
                return '?page=' + page;
            },
            pagesToList: 5
        };
    },


    /**
     * Clicked to select a page
     * @param  {Number} i
     */
    onSelectPage: function onSelectPage(i, e) {
        if (this.props.onChange) {
            e.preventDefault();
            return this.props.onChange(i);
        }
    },


    /**
     * Render a page selector
     * @param {Number} i
     * @param {String} text
     * @return {React.Element}
     */
    renderPageItem: function renderPageItem(i, text) {
        var page = this.props.page;
        var isActive = i === page;
        var className = classNames({
            active: isActive
        });
        var uri = this.props.getURL(i);

        return React.createElement(
            'li',
            { key: i, className: className },
            React.createElement(
                'a',
                { href: uri, onClick: this.onSelectPage.bind(this, i) },
                text || i + 1
            )
        );
    },
    render: function render() {
        var page = this.props.page;
        var pages = this.props.pages;
        var pagesToList = this.props.pagesToList;

        if (pages < 2) {
            return React.createElement('div', null);
        }

        if (page < 0) page = 0;
        if (page >= pages) page = pages - 1;

        var startRange = Math.max(0, page - pagesToList);
        var maxRange = pages;
        var endRange = Math.min(maxRange, page + pagesToList);
        var pagesRange = (0, _from2.default)(Array(pages)).map(Number.call, Number).slice(startRange, endRange);

        return React.createElement(
            'div',
            { className: 'pagination' },
            React.createElement(
                'ul',
                { className: 'pagination-pages' },
                startRange === 0 ? '' : this.renderPageItem(0),
                startRange === 0 ? '' : React.createElement(
                    'li',
                    null,
                    React.createElement(
                        'span',
                        { className: 'separator' },
                        '...'
                    )
                ),
                pagesRange.map(function (i) {
                    return this.renderPageItem(i);
                }, this),
                endRange === maxRange ? '' : React.createElement(
                    'li',
                    null,
                    React.createElement(
                        'span',
                        { className: 'separator' },
                        '...'
                    )
                ),
                endRange === maxRange ? '' : this.renderPageItem(maxRange)
            ),
            React.createElement(
                'ul',
                { className: 'pagination-nav' },
                page < 1 ? '' : this.renderPageItem(page - 1, '« previous page'),
                page >= maxRange - 1 ? '' : this.renderPageItem(page + 1, 'next page »')
            )
        );
    }
});

module.exports = Pagination;