'use strict';

var React = require('/Users/samypesse/Projects/GitBook/styleguide/node_modules/react/react.js');
var classNames = require('classnames');
var SIZES = require('./SIZES');

var Row = React.createClass({
    displayName: 'Row',

    propTypes: {
        children: React.PropTypes.node
    },

    render: function render() {
        return React.createElement(
            'div',
            { className: 'row' },
            this.props.children
        );
    }
});

var Container = require('./Container');

var Column = React.createClass({
    displayName: 'Column',

    propTypes: {
        children: React.PropTypes.node,
        className: React.PropTypes.string
    },

    render: function render() {
        var _this = this;

        var _props = this.props,
            children = _props.children,
            className = _props.className;


        var cl = classNames(className, SIZES.reduce(function (list, size) {
            var col = _this.props[size];
            var offset = _this.props[size + 'Offset'];

            if (col) {
                list.push(['col', size, col].join('-'));
            }
            if (offset) {
                list.push(['col', size, 'offset', offset].join('-'));
            }

            return list;
        }, []));

        return React.createElement(
            'div',
            { className: cl },
            children
        );
    }
});

module.exports = Row;
module.exports.Container = Container;
module.exports.Col = Column;