'use strict';

var React = require('/Users/samypesse/Projects/GitBook/styleguide/node_modules/react/react.js');
var classNames = require('classnames');

var Icon = require('./Icon');
var Form = require('./Form');
var Input = require('./Input');

var SearchBar = React.createClass({
    displayName: 'SearchBar',

    propTypes: {
        className: React.PropTypes.string,
        placeholder: React.PropTypes.string,
        value: React.PropTypes.string,
        action: React.PropTypes.string,
        name: React.PropTypes.string,
        method: React.PropTypes.string,
        onSubmit: React.PropTypes.func,
        onChange: React.PropTypes.func
    },

    getDefaultProps: function getDefaultProps() {
        return {
            method: 'get'
        };
    },
    getInitialState: function getInitialState() {
        return {
            value: this.props.value
        };
    },
    componentWillReceiveProps: function componentWillReceiveProps(newProps) {
        this.setState({
            value: newProps.value
        });
    },
    onChange: function onChange(e) {
        var value = e.target.value;


        this.setState({ value: value });

        if (this.props.onChange) {
            this.props.onChange(value);
        }
    },
    onSubmit: function onSubmit(e) {
        if (this.props.onSubmit) {
            e.preventDefault();
            this.props.onSubmit(this.state.value);
        }
    },
    render: function render() {
        var _props = this.props,
            action = _props.action,
            placeholder = _props.placeholder,
            name = _props.name,
            method = _props.method;
        var value = this.state.value;


        return React.createElement(
            Form,
            { className: classNames('search-bar', this.props.className),
                method: method,
                action: action },
            React.createElement(Icon, { id: 'search', size: 'sm' }),
            React.createElement(Input, { name: name,
                value: value,
                onChange: this.onChange,
                placeholder: placeholder })
        );
    }
});

module.exports = SearchBar;