'use strict';

var React = require('/Users/samypesse/Projects/GitBook/styleguide/node_modules/react/react.js');
var classNames = require('classnames');

var SIZES = require('./SIZES');

var Spinner = React.createClass({
    displayName: 'Spinner',

    propTypes: {
        centered: React.PropTypes.bool,
        inverse: React.PropTypes.bool,
        size: React.PropTypes.oneOf(SIZES)
    },

    getDefaultProps: function getDefaultProps() {
        return {
            centered: true,
            size: 'md'
        };
    },
    render: function render() {
        var className = classNames('gb-spinner', 'spinner-' + this.props.size, {
            'spinner-inverse': this.props.inverse,
            'spinner-centered': this.props.centered
        });

        return React.createElement('span', { className: className });
    }
});

/**
 * Block div representing a loading area
 */
var SpinnerSlate = React.createClass({
    displayName: 'SpinnerSlate',
    render: function render() {
        return React.createElement(
            'div',
            { className: 'gb-spinner-slate' },
            React.createElement(Spinner, this.props)
        );
    }
});

module.exports = Spinner;
module.exports.Slate = SpinnerSlate;