'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
var React = require('/Users/samypesse/Projects/GitBook/styleguide/node_modules/react/react.js');

var Page = require('./components/Page');
var Panel = require('../src/Panel');
var Container = require('../src/Container');
var Row = require('../src/Row');
var Icon = require('../src/Icon');
var LogoText = require('../icons/LogoText');
var Logo = require('../icons/Logo');

var CodeEditor = require('./components/CodeEditor');

var SOURCE_IMPORT = 'const LogoText = require(\'gitbook-styleguide/icons/LogoText\');\nconst Logo = require(\'gitbook-styleguide/icons/Logo\');\nconst Icon = require(\'gitbook-styleguide/icons/Icon\');';

var LOGOS = [{ source: '<LogoText />', component: function component() {
        return React.createElement(LogoText, { size: 'md' });
    } }, { source: '<Logo />', component: function component() {
        return React.createElement(Logo, { size: 'md' });
    } }];

var OCTICONS = Icon.OCTICONS.map(function (id) {
    return {
        source: '<Icon id="' + id + '" />',
        component: function component() {
            return React.createElement(
                'span',
                { style: { fontSize: 32 } },
                React.createElement(Icon, { id: id, size: 'md' })
            );
        }
    };
});

var IconsSet = React.createClass({
    displayName: 'IconsSet',

    propTypes: {
        icons: React.PropTypes.array.isRequired,
        perLine: React.PropTypes.number
    },

    getDefaultProps: function getDefaultProps() {
        return {
            perLine: 4
        };
    },
    render: function render() {
        var _props = this.props,
            icons = _props.icons,
            perLine = _props.perLine;

        var lines = [];

        while (icons.length > 0) {
            var cells = icons.splice(0, perLine);
            lines.push(React.createElement(
                Row,
                null,
                cells.map(function (cell) {
                    return React.createElement(
                        Row.Col,
                        { md: 12 / perLine },
                        React.createElement(
                            Panel,
                            null,
                            React.createElement(
                                Panel.Body,
                                null,
                                React.createElement(
                                    'div',
                                    { style: { textAlign: 'center' } },
                                    React.createElement(cell.component, null)
                                )
                            ),
                            React.createElement(
                                Panel.Body,
                                null,
                                React.createElement(
                                    'div',
                                    { style: { textAlign: 'center' } },
                                    React.createElement(
                                        'code',
                                        null,
                                        cell.source
                                    )
                                )
                            )
                        )
                    );
                })
            ));
        }

        return React.createElement(
            Container,
            { fluid: true },
            lines
        );
    }
});

exports.default = function () {
    return React.createElement(
        Page,
        { title: 'Logos and Icons', active: 'icons' },
        React.createElement(
            Panel,
            null,
            React.createElement(Panel.Heading, { title: 'Logos and Icons' }),
            React.createElement(
                Panel.Body,
                null,
                React.createElement(
                    'p',
                    null,
                    'The styleguide provides all logos and icons as react component (rendered as an SVG).'
                ),
                React.createElement(
                    'p',
                    null,
                    'GitBook Styleguide is currently providing the octicons icons set.'
                ),
                React.createElement(CodeEditor, { source: SOURCE_IMPORT })
            )
        ),
        React.createElement(IconsSet, { icons: LOGOS }),
        React.createElement(IconsSet, { icons: OCTICONS })
    );
};