'use strict';

var React = require('react');

/**
 * Backdrop for modals, dropdown, popover.
 *
 *
 * For example:
 *
 * <Backdrop onClose={onClosePopover}>
 *      <Popover>...</Popover>
 * </Backdrop>
 */
var Backdrop = React.createClass({
    displayName: 'Backdrop',

    propTypes: {
        // Close on escape
        escape: React.PropTypes.bool,
        // Z-index for the backdrop
        zIndex: React.PropTypes.number,
        // Callback when backdrop is closed
        onClose: React.PropTypes.func.isRequired,
        children: React.PropTypes.node.isRequired,
        wrapper: React.PropTypes.node
    },

    getDefaultProps: function getDefaultProps() {
        return {
            escape: true,
            zIndex: 200,
            wrapper: React.createElement('div', null)
        };
    },
    onClose: function onClose() {
        var onClose = this.props.onClose;

        onClose();
    },
    onKeyDown: function onKeyDown(event) {
        var escape = this.props.escape;


        if (event.keyCode === 27 && escape) {
            this.onClose();
        }
    },
    componentDidMount: function componentDidMount() {
        window.addEventListener('keydown', this.onKeyDown);
    },
    componentWillUnmount: function componentWillUnmount() {
        window.removeEventListener('keydown', this.onKeyDown);
    },
    render: function render() {
        var _props = this.props,
            zIndex = _props.zIndex,
            wrapper = _props.wrapper;

        var style = {
            zIndex: zIndex,
            position: 'fixed',
            top: 0,
            right: 0,
            width: '100%',
            height: '100%'
        };

        return React.cloneElement(wrapper, {}, React.createElement('div', { style: style, onClick: this.onClose }), wrapper.props.children, this.props.children);
    }
});

module.exports = Backdrop;
//# sourceMappingURL=data:application/json;base64,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