'use strict';

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var React = require('react');
var classNames = require('classnames');

var SIZES = require('./SIZES');

var Input = React.createClass({
    displayName: 'Input',

    propTypes: {
        className: React.PropTypes.string,
        onChange: React.PropTypes.func,
        onFocus: React.PropTypes.func,
        onBlur: React.PropTypes.func,
        onPaste: React.PropTypes.func,
        onKeyDown: React.PropTypes.func,
        onClick: React.PropTypes.func,
        name: React.PropTypes.string,
        type: React.PropTypes.string,
        placeholder: React.PropTypes.string,
        disabled: React.PropTypes.bool,
        focus: React.PropTypes.bool,
        readOnly: React.PropTypes.bool,
        autoFocus: React.PropTypes.bool,
        size: React.PropTypes.oneOf(SIZES),
        defaultValue: React.PropTypes.string,
        value: React.PropTypes.oneOfType([React.PropTypes.string, React.PropTypes.bool])
    },

    /**
     * Focus this input
     */
    focus: function focus() {
        this.refs.input.focus();
    },
    getDefaultProps: function getDefaultProps() {
        return {
            type: 'text',
            size: SIZES[0]
        };
    },
    onChange: function onChange(e) {
        if (this.props.onChange) {
            this.props.onChange(e);
        }
    },
    render: function render() {
        var _props = this.props,
            onPaste = _props.onPaste,
            onBlur = _props.onBlur,
            onFocus = _props.onFocus,
            onKeyDown = _props.onKeyDown,
            onClick = _props.onClick,
            value = _props.value,
            readOnly = _props.readOnly,
            defaultValue = _props.defaultValue,
            size = _props.size,
            autoFocus = _props.autoFocus,
            placeholder = _props.placeholder,
            type = _props.type,
            focus = _props.focus,
            name = _props.name,
            disabled = _props.disabled;


        var className = classNames('form-control', 'input-' + size, this.props.className, {
            focus: focus
        });

        return React.createElement('input', { ref: 'input',
            type: type, autoFocus: autoFocus,
            className: className, disabled: disabled, readOnly: readOnly,
            name: name, value: value, defaultValue: defaultValue,
            placeholder: placeholder,
            onFocus: onFocus,
            onBlur: onBlur,
            onKeyDown: onKeyDown,
            onClick: onClick,
            onPaste: onPaste,
            onChange: this.onChange
        });
    }
});

/**
 * Create a style of alert
 * @param {String} style
 * @return {React.Component}
 */
function createInputType(type) {
    return React.createClass({
        displayName: Input.displayName + type,
        render: function render() {
            return React.createElement(Input, _extends({}, this.props, { type: type.toLowerCase() }));
        }
    });
}

var InputGroup = React.createClass({
    displayName: 'InputGroup',

    propTypes: {
        children: React.PropTypes.node,
        className: React.PropTypes.string
    },

    render: function render() {
        var className = classNames('input-group', this.props.className || []);
        return React.createElement(
            'div',
            { className: className },
            this.props.children
        );
    }
});

var InputGroupAddon = React.createClass({
    displayName: 'InputGroupAddon',

    propTypes: {
        children: React.PropTypes.node
    },

    render: function render() {
        return React.createElement(
            'span',
            _extends({}, this.props, { className: 'input-group-addon' }),
            this.props.children
        );
    }
});

module.exports = Input;
module.exports.Email = createInputType('Email');
module.exports.Password = createInputType('Password');
module.exports.Group = InputGroup;
module.exports.GroupAddon = InputGroupAddon;
//# sourceMappingURL=data:application/json;base64,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