'use strict';

var React = require('react');
var classNames = require('classnames');

var SIZES = require('./SIZES');

var Textarea = React.createClass({
    displayName: 'Textarea',

    propTypes: {
        onChange: React.PropTypes.func,
        name: React.PropTypes.string,
        className: React.PropTypes.string,
        placeholder: React.PropTypes.string,
        disabled: React.PropTypes.bool,
        autoFocus: React.PropTypes.bool,
        size: React.PropTypes.oneOf(SIZES),
        rows: React.PropTypes.number,
        maxLength: React.PropTypes.number,
        defaultValue: React.PropTypes.string,
        value: React.PropTypes.oneOfType([React.PropTypes.string, React.PropTypes.bool])
    },

    /**
     * Focus this input
     */
    focus: function focus() {
        this.refs.textarea.focus();
    },
    getDefaultProps: function getDefaultProps() {
        return {
            size: SIZES[0],
            rows: 3
        };
    },
    onChange: function onChange(e) {
        if (this.props.onChange) {
            this.props.onChange(e);
        }
    },
    render: function render() {
        var _props = this.props,
            disabled = _props.disabled,
            name = _props.name,
            placeholder = _props.placeholder,
            size = _props.size,
            rows = _props.rows,
            autoFocus = _props.autoFocus,
            value = _props.value,
            defaultValue = _props.defaultValue,
            maxLength = _props.maxLength;


        var className = classNames('form-control', 'input-' + size, this.props.className);

        return React.createElement('textarea', { ref: 'textarea',
            className: className, rows: rows, maxLength: maxLength,
            autoFocus: autoFocus, disabled: disabled,
            name: name, value: value, defaultValue: defaultValue,
            placeholder: placeholder, onChange: this.onChange });
    }
});

module.exports = Textarea;
//# sourceMappingURL=data:application/json;base64,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