webpackHotUpdate(12,{

/***/ 112:
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var React = __webpack_require__(87);
	var classNames = __webpack_require__(102);

	var STYLES = __webpack_require__(113);

	var Panel = React.createClass({
	    displayName: 'Panel',

	    propTypes: {
	        style: React.PropTypes.oneOf(STYLES),
	        children: React.PropTypes.node
	    },

	    getDefaultProps: function getDefaultProps() {
	        return {
	            style: STYLES[0]
	        };
	    },
	    render: function render() {
	        var style = this.props.style;

	        return React.createElement(
	            'div',
	            { className: classNames('panel', 'panel-' + style) },
	            this.props.children
	        );
	    }
	});

	var PanelHeading = React.createClass({
	    displayName: 'PanelHeading',

	    propTypes: {
	        title: React.PropTypes.string,
	        children: React.PropTypes.node
	    },

	    render: function render() {
	        var title = this.props.title;
	        var inner = '';

	        if (title) {
	            inner = React.createElement(
	                PanelTitle,
	                null,
	                title
	            );
	        }

	        return React.createElement(
	            'div',
	            { className: 'panel-heading' },
	            inner,
	            this.props.children
	        );
	    }
	});

	var PanelTitle = React.createClass({
	    displayName: 'PanelTitle',

	    propTypes: {
	        children: React.PropTypes.node
	    },

	    render: function render() {
	        return React.createElement(
	            'h3',
	            { className: 'panel-title' },
	            this.props.children
	        );
	    }
	});

	var PanelToolbar = React.createClass({
	    displayName: 'PanelToolbar',

	    propTypes: {
	        children: React.PropTypes.node
	    },

	    render: function render() {
	        return React.createElement(
	            'div',
	            { className: 'panel-toolbar' },
	            this.props.children
	        );
	    }
	});

	var PanelBody = React.createClass({
	    displayName: 'PanelBody',

	    propTypes: {
	        children: React.PropTypes.node
	    },

	    render: function render() {
	        return React.createElement(
	            'div',
	            { className: 'panel-body' },
	            this.props.children
	        );
	    }
	});

	var PanelFooter = React.createClass({
	    displayName: 'PanelFooter',

	    propTypes: {
	        children: React.PropTypes.node
	    },

	    render: function render() {
	        return React.createElement(
	            'div',
	            { className: 'panel-footer' },
	            this.props.children
	        );
	    }
	});

	module.exports = Panel;
	module.exports.Heading = PanelHeading;
	module.exports.Title = PanelTitle;
	module.exports.Body = PanelBody;
	module.exports.Footer = PanelFooter;
	module.exports.Toolbar = PanelToolbar;

/***/ },

/***/ 114:
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var React = __webpack_require__(87);
	var classNames = __webpack_require__(102);
	var SIZES = __webpack_require__(115);

	var Row = React.createClass({
	    displayName: 'Row',

	    propTypes: {
	        children: React.PropTypes.node
	    },

	    render: function render() {
	        return React.createElement(
	            'div',
	            { className: 'row' },
	            this.props.children
	        );
	    }
	});

	var Container = __webpack_require__(105);

	var Column = React.createClass({
	    displayName: 'Column',

	    propTypes: {
	        children: React.PropTypes.node,
	        // oneOf(SIZES): React.PropTypes.number,
	        offset: React.PropTypes.number
	    },

	    render: function render() {
	        var _this = this;

	        var _props = this.props,
	            offset = _props.offset,
	            children = _props.children;


	        var className = classNames(SIZES.reduce(function (list, size) {
	            var col = _this.props[size];

	            if (col) {
	                list.push(['col', size, col].join('-'));
	            }
	            if (col && offset) {
	                list.push(['col', size, 'offset', offset].join('-'));
	            }

	            return list;
	        }, []));

	        return React.createElement(
	            'div',
	            { className: className },
	            children
	        );
	    }
	});

	module.exports = Row;
	module.exports.Container = Container;
	module.exports.Col = Column;

/***/ },

/***/ 118:
/***/ function(module, exports, __webpack_require__) {

	"use strict";

	var React = __webpack_require__(87);

	var PageFooter = React.createClass({
	    displayName: "PageFooter",

	    propTypes: {
	        children: React.PropTypes.node
	    },

	    render: function render() {
	        return React.createElement(
	            "div",
	            { className: "gb-page-footer" },
	            this.props.children
	        );
	    }
	});

	module.exports = PageFooter;

/***/ },

/***/ 124:
/***/ function(module, exports, __webpack_require__) {

	"use strict";

	var React = __webpack_require__(87);

	var PageHeader = React.createClass({
	    displayName: "PageHeader",

	    propTypes: {
	        children: React.PropTypes.node
	    },

	    render: function render() {
	        return React.createElement(
	            "div",
	            { className: "gb-page-header" },
	            this.props.children
	        );
	    }
	});

	var Logo = React.createClass({
	    displayName: "Logo",

	    propTypes: {
	        href: React.PropTypes.string,
	        src: React.PropTypes.string,
	        children: React.PropTypes.node
	    },

	    render: function render() {
	        var _props = this.props,
	            href = _props.href,
	            src = _props.src;


	        return React.createElement(
	            "a",
	            { href: href, className: "logo pull-left" },
	            React.createElement("img", { src: src }),
	            React.createElement(
	                "h1",
	                null,
	                this.props.children
	            )
	        );
	    }
	});

	module.exports = PageHeader;
	module.exports.Logo = Logo;

/***/ },

/***/ 126:
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var _extends2 = __webpack_require__(106);

	var _extends3 = _interopRequireDefault(_extends2);

	var _objectWithoutProperties2 = __webpack_require__(111);

	var _objectWithoutProperties3 = _interopRequireDefault(_objectWithoutProperties2);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	var React = __webpack_require__(87);
	var classNames = __webpack_require__(102);

	var Icon = __webpack_require__(127);
	var STYLES = __webpack_require__(113);
	var SIZES = __webpack_require__(115);

	var BUTTONS_STYLES = STYLES.concat(['link', 'text-link', 'text-danger', 'text-success', 'text-warning', 'count']);

	var Button = React.createClass({
	    displayName: 'Button',

	    propTypes: {
	        className: React.PropTypes.string,
	        children: React.PropTypes.node,
	        type: React.PropTypes.string,
	        size: React.PropTypes.oneOf(SIZES),
	        style: React.PropTypes.oneOf(BUTTONS_STYLES),
	        // Makes a link button
	        href: React.PropTypes.string,
	        // Form button
	        value: React.PropTypes.oneOfType([React.PropTypes.string, React.PropTypes.bool, React.PropTypes.number]),
	        name: React.PropTypes.string,
	        // For links
	        target: React.PropTypes.string,
	        filled: React.PropTypes.bool,
	        noBorder: React.PropTypes.bool,
	        disabled: React.PropTypes.bool,
	        active: React.PropTypes.bool,
	        block: React.PropTypes.bool,
	        dropdownToggle: React.PropTypes.bool,
	        onClick: React.PropTypes.func,
	        title: React.PropTypes.string,
	        icon: React.PropTypes.string
	    },

	    getInitialState: function getInitialState() {
	        return {
	            clicked: false
	        };
	    },
	    getDefaultProps: function getDefaultProps() {
	        return {
	            style: 'default',
	            size: 'md',
	            type: 'button',
	            filled: false,
	            disabled: false,
	            active: false
	        };
	    },
	    onClick: function onClick(e) {
	        var _this = this;

	        var clicked = this.state.clicked;


	        if (this.props.onClick && !clicked) {
	            this.props.onClick(e);
	        }

	        if (!this.isFormButton()) {
	            return;
	        } else if (clicked) {
	            return this.setState({
	                clicked: false
	            });
	        }

	        // Add this submitting button's value to the form as hidden
	        // input. Only after that do the click.
	        // This fixes issues with PJAX[1] in Firefox[2]
	        // [1]: https://github.com/defunkt/jquery-pjax/pull/295
	        // [2]: http://stackoverflow.com/questions/38277900/formdata-object-does-not-add-submit-type-inputs-from-form-while-on-firefox
	        e.preventDefault();
	        this.setState({
	            clicked: true
	        }, function () {
	            _this.refs.button.click();
	        });
	    },
	    isFormButton: function isFormButton() {
	        var _props = this.props,
	            type = _props.type,
	            name = _props.name;

	        return type === 'submit' && name;
	    },
	    render: function render() {
	        var clicked = this.state.clicked;
	        var _props2 = this.props,
	            title = _props2.title,
	            icon = _props2.icon,
	            filled = _props2.filled,
	            block = _props2.block,
	            noBorder = _props2.noBorder,
	            active = _props2.active,
	            dropdownToggle = _props2.dropdownToggle,
	            style = _props2.style,
	            size = _props2.size,
	            className = _props2.className,
	            children = _props2.children,
	            name = _props2.name,
	            value = _props2.value,
	            props = (0, _objectWithoutProperties3.default)(_props2, ['title', 'icon', 'filled', 'block', 'noBorder', 'active', 'dropdownToggle', 'style', 'size', 'className', 'children', 'name', 'value']);


	        var inner = icon ? React.createElement(Icon, { className: icon }) : '';

	        props.className = classNames('btn', 'btn-' + style, 'btn-' + size, className, {
	            'btn-fill': filled,
	            'btn-block': block,
	            'btn-noborder': noBorder,
	            active: active,
	            'dropdown-toggle': dropdownToggle,
	            'tooltipped': Boolean(title)
	        });
	        props['aria-label'] = title;
	        props.role = 'button';
	        props.onClick = this.onClick;

	        var input = void 0;

	        if (clicked && this.isFormButton()) {
	            input = React.createElement('input', { type: 'hidden', name: name, value: value });
	        }

	        if (props.href) {
	            delete props.type;
	            return React.createElement(
	                'a',
	                props,
	                inner,
	                ' ',
	                children
	            );
	        } else {
	            return React.createElement(
	                'button',
	                (0, _extends3.default)({ ref: 'button' }, props),
	                inner,
	                ' ',
	                children,
	                input
	            );
	        }
	    }
	});

	var ButtonGroup = React.createClass({
	    displayName: 'ButtonGroup',

	    propTypes: {
	        className: React.PropTypes.string,
	        children: React.PropTypes.node,
	        pull: React.PropTypes.string,
	        block: React.PropTypes.bool
	    },

	    render: function render() {
	        var _props3 = this.props,
	            className = _props3.className,
	            pull = _props3.pull,
	            children = _props3.children,
	            block = _props3.block;


	        className = classNames('btn-group', className, pull ? 'pull-' + pull : '', {
	            'btn-group-block': block
	        });

	        return React.createElement(
	            'div',
	            { className: className },
	            children
	        );
	    }
	});

	var ButtonToolbar = React.createClass({
	    displayName: 'ButtonToolbar',

	    propTypes: {
	        className: React.PropTypes.string,
	        children: React.PropTypes.node
	    },

	    render: function render() {
	        return React.createElement(
	            'div',
	            { className: 'btn-toolbar ' + (this.props.className || '') },
	            this.props.children
	        );
	    }
	});

	var ButtonCaret = React.createClass({
	    displayName: 'ButtonCaret',
	    render: function render() {
	        return React.createElement('span', { className: 'caret' });
	    }
	});

	var ButtonTextExpander = React.createClass({
	    displayName: 'ButtonTextExpander',

	    propTypes: {
	        onClick: React.PropTypes.func
	    },

	    onClick: function onClick(e) {
	        if (this.props.onClick) {
	            this.props.onClick();
	        }
	    },
	    render: function render() {
	        return React.createElement(
	            'span',
	            { className: 'hidden-text-expander' },
	            React.createElement(
	                'button',
	                { type: 'button', className: 'ellipsis-expander', onClick: this.onClick },
	                '\u2026'
	            )
	        );
	    }
	});

	module.exports = Button;
	module.exports.Group = ButtonGroup;
	module.exports.Toolbar = ButtonToolbar;
	module.exports.Caret = ButtonCaret;
	module.exports.TextExpander = ButtonTextExpander;
	module.exports.STYLES = BUTTONS_STYLES;

/***/ },

/***/ 127:
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var React = __webpack_require__(87);
	var classNames = __webpack_require__(102);

	var Icon = React.createClass({
	    displayName: 'Icon',

	    propTypes: {
	        // Icon of the icon in the collection
	        id: React.PropTypes.string,
	        // Type of collection
	        type: React.PropTypes.string,
	        // Extra className
	        className: React.PropTypes.string,
	        // Is the icon spinning?
	        spin: React.PropTypes.bool
	    },

	    getDefaultProps: function getDefaultProps() {
	        return {
	            type: 'octicon',
	            spin: false
	        };
	    },
	    render: function render() {
	        var _props = this.props,
	            type = _props.type,
	            id = _props.id,
	            className = _props.className,
	            spin = _props.spin;


	        className = classNames(type + ' ' + type + '-' + id, className, {
	            'icon-spin': spin
	        });

	        return React.createElement('i', { className: className });
	    }
	});

	module.exports = Icon;

/***/ },

/***/ 498:
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var _extends2 = __webpack_require__(106);

	var _extends3 = _interopRequireDefault(_extends2);

	var _objectWithoutProperties2 = __webpack_require__(111);

	var _objectWithoutProperties3 = _interopRequireDefault(_objectWithoutProperties2);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	var React = __webpack_require__(87);
	var classNames = __webpack_require__(102);

	var Button = __webpack_require__(126);
	var Icon = __webpack_require__(127);
	var Backdrop = __webpack_require__(499);

	/**
	 * Dropdown (or up). Automatically bound to child Button.
	 * See ButtonDropdown implementation to wrap something else than a button.
	 *
	 * <Dropdown>
	 *
	 *     <Button ... />
	 *
	 *     <Dropdown.Item header>Category 1</Dropdown.Item>
	 *     <Dropdown.Item href={...}> ... </Dropdown.Item>
	 *     <Dropdown.Item href={...}> ... </Dropdown.Item>
	 *
	 *     <Dropdown.Item divider />
	 *     <Dropdown.Item header>Category 2</Dropdown.Item>
	 *     <Dropdown.Item href={...}> ... </Dropdown.Item>
	 *     <Dropdown.Item href={...}> ... </Dropdown.Item>
	 *
	 *     <Dropdown.Item>
	 *         A submenu
	 *         <Dropdown.Menu open={false}> // CSS takes care of display on hover
	 *             <Dropdown.Item href={...}> Subitem </Dropdown.Item>
	 *         </Dropdown.Menu>
	 *     </Dropdown.Item>
	 *
	 * </Dropdown>
	 */

	var ButtonDropdown = React.createClass({
	    displayName: 'ButtonDropdown',

	    propTypes: {
	        className: React.PropTypes.string,
	        children: React.PropTypes.node,
	        up: React.PropTypes.bool,
	        width: React.PropTypes.string
	    },

	    getInitialState: function getInitialState() {
	        return {
	            open: false
	        };
	    },


	    /**
	     * Toggle the dopdown
	     * @param  {Event} e?
	     */
	    toggle: function toggle(e) {
	        if (e) {
	            e.stopPropagation();
	        }

	        this.setState({
	            open: !this.state.open
	        });
	    },


	    /**
	     * Close the dropdown
	     */
	    close: function close() {
	        this.setState({
	            open: false
	        });
	    },
	    render: function render() {
	        var that = this;
	        var inner = [];
	        var items = [];

	        var _props = this.props,
	            className = _props.className,
	            children = _props.children,
	            up = _props.up,
	            width = _props.width,
	            otherProps = (0, _objectWithoutProperties3.default)(_props, ['className', 'children', 'up', 'width']);
	        var open = this.state.open;


	        className = classNames('dropdown', className, {
	            'dropup': up
	        });

	        inner = React.Children.map(children, function (child) {
	            // If the Button is connected through Redux.connect, it is
	            // renamed to "Connect(Button...)"
	            if (child && child.type && child.type.displayName && child.type.displayName.indexOf('Button') !== -1) {
	                if (!child.props.onClick && !child.props.href) {
	                    return React.cloneElement(child, {
	                        onClick: that.toggle,
	                        dropdownToggle: true
	                    });
	                }
	                return child;
	            }

	            return null;
	        });

	        items = React.Children.map(children, function (child) {
	            if (child && child.type && child.type.displayName == 'DropdownItem') {
	                return React.cloneElement(child, {
	                    onClick: function onClick() {
	                        if (child.props.onClick) {
	                            child.props.onClick();
	                        }
	                        that.close();
	                    }
	                });
	            }
	            return null;
	        });

	        var content = React.createElement(
	            Button.Group,
	            (0, _extends3.default)({}, otherProps, { className: className }),
	            inner
	        );

	        // Wrap in a backdrop when open
	        if (open) {
	            return React.createElement(
	                Backdrop,
	                { wrapper: content, onClose: this.close },
	                open ? React.createElement(
	                    DropdownMenu,
	                    { width: width },
	                    items
	                ) : null
	            );
	        } else {
	            return content;
	        }
	    }
	});

	var DropdownItem = React.createClass({
	    displayName: 'DropdownItem',

	    propTypes: {
	        children: React.PropTypes.node,
	        onClick: React.PropTypes.func,
	        href: React.PropTypes.string,
	        disabled: React.PropTypes.bool,
	        divider: React.PropTypes.bool,
	        header: React.PropTypes.bool,
	        checked: React.PropTypes.bool
	    },

	    onClick: function onClick(e) {
	        if (!this.props.href) {
	            e.preventDefault();
	            e.stopPropagation();

	            if (this.props.onClick) this.props.onClick();
	        }
	    },
	    isInner: function isInner(child) {
	        return !child || !child.type || child.type.displayName !== 'DropdownMenu';
	    },
	    render: function render() {
	        var _props2 = this.props,
	            divider = _props2.divider,
	            header = _props2.header,
	            checked = _props2.checked;


	        if (divider) {
	            return React.createElement('li', { className: 'divider' });
	        }
	        if (header) {
	            return React.createElement(
	                'li',
	                { className: 'dropdown-header' },
	                this.props.children
	            );
	        }

	        var inner = [],
	            outer = [];

	        inner = React.Children.map(this.props.children, function (child) {
	            if (this.isInner(child)) return child;
	            return null;
	        }, this);

	        outer = React.Children.map(this.props.children, function (child) {
	            if (!this.isInner(child)) return child;
	            return null;
	        }, this);

	        return React.createElement(
	            'li',
	            { className: this.props.disabled ? 'disabled' : '' },
	            React.createElement(
	                'a',
	                (0, _extends3.default)({}, this.props, { href: this.props.href || '#', onClick: this.props.disabled ? null : this.onClick }),
	                checked ? React.createElement(
	                    'div',
	                    { className: 'dropdown-icon pull-left' },
	                    React.createElement(Icon, { id: 'check' })
	                ) : '',
	                inner
	            ),
	            outer
	        );
	    }
	});

	var DropdownMenu = React.createClass({
	    displayName: 'DropdownMenu',

	    propTypes: {
	        className: React.PropTypes.string,
	        children: React.PropTypes.node,
	        open: React.PropTypes.bool,
	        width: React.PropTypes.string
	    },

	    getDefaultProps: function getDefaultProps() {
	        return {
	            open: true,
	            width: null
	        };
	    },
	    render: function render() {
	        var width = this.props.width;

	        var className = classNames('dropdown-menu', width ? 'dropdown-' + width : '', {
	            open: this.props.open
	        });

	        return React.createElement(
	            'ul',
	            { className: className },
	            this.props.children
	        );
	    }
	});

	var ItemHeader = React.createClass({
	    displayName: 'ItemHeader',

	    propTypes: {
	        children: React.PropTypes.node
	    },

	    render: function render() {
	        return React.createElement(
	            'div',
	            { className: 'dropdown-itemheader' },
	            this.props.children
	        );
	    }
	});

	var ItemDesc = React.createClass({
	    displayName: 'ItemDesc',

	    propTypes: {
	        children: React.PropTypes.node
	    },

	    render: function render() {
	        return React.createElement(
	            'div',
	            { className: 'dropdown-itemdesc' },
	            this.props.children
	        );
	    }
	});

	module.exports = ButtonDropdown;
	module.exports.Item = DropdownItem;
	module.exports.Item.Header = ItemHeader;
	module.exports.Item.Desc = ItemDesc;
	module.exports.Menu = DropdownMenu;

/***/ }

})