webpackHotUpdate(13,{

/***/ 112:
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var React = __webpack_require__(87);
	var classNames = __webpack_require__(102);

	var STYLES = __webpack_require__(113);

	var Panel = React.createClass({
	    displayName: 'Panel',

	    propTypes: {
	        style: React.PropTypes.oneOf(STYLES),
	        children: React.PropTypes.node
	    },

	    getDefaultProps: function getDefaultProps() {
	        return {
	            style: STYLES[0]
	        };
	    },
	    render: function render() {
	        var style = this.props.style;

	        return React.createElement(
	            'div',
	            { className: classNames('panel', 'panel-' + style) },
	            this.props.children
	        );
	    }
	});

	var PanelHeading = React.createClass({
	    displayName: 'PanelHeading',

	    propTypes: {
	        title: React.PropTypes.string,
	        children: React.PropTypes.node
	    },

	    render: function render() {
	        var title = this.props.title;
	        var inner = '';

	        if (title) {
	            inner = React.createElement(
	                PanelTitle,
	                null,
	                title
	            );
	        }

	        return React.createElement(
	            'div',
	            { className: 'panel-heading' },
	            inner,
	            this.props.children
	        );
	    }
	});

	var PanelTitle = React.createClass({
	    displayName: 'PanelTitle',

	    propTypes: {
	        children: React.PropTypes.node
	    },

	    render: function render() {
	        return React.createElement(
	            'h3',
	            { className: 'panel-title' },
	            this.props.children
	        );
	    }
	});

	var PanelToolbar = React.createClass({
	    displayName: 'PanelToolbar',

	    propTypes: {
	        children: React.PropTypes.node
	    },

	    render: function render() {
	        return React.createElement(
	            'div',
	            { className: 'panel-toolbar' },
	            this.props.children
	        );
	    }
	});

	var PanelBody = React.createClass({
	    displayName: 'PanelBody',

	    propTypes: {
	        children: React.PropTypes.node
	    },

	    render: function render() {
	        return React.createElement(
	            'div',
	            { className: 'panel-body' },
	            this.props.children
	        );
	    }
	});

	var PanelFooter = React.createClass({
	    displayName: 'PanelFooter',

	    propTypes: {
	        children: React.PropTypes.node
	    },

	    render: function render() {
	        return React.createElement(
	            'div',
	            { className: 'panel-footer' },
	            this.props.children
	        );
	    }
	});

	module.exports = Panel;
	module.exports.Heading = PanelHeading;
	module.exports.Title = PanelTitle;
	module.exports.Body = PanelBody;
	module.exports.Footer = PanelFooter;
	module.exports.Toolbar = PanelToolbar;

/***/ },

/***/ 114:
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var React = __webpack_require__(87);
	var classNames = __webpack_require__(102);
	var SIZES = __webpack_require__(115);

	var Row = React.createClass({
	    displayName: 'Row',

	    propTypes: {
	        children: React.PropTypes.node
	    },

	    render: function render() {
	        return React.createElement(
	            'div',
	            { className: 'row' },
	            this.props.children
	        );
	    }
	});

	var Container = __webpack_require__(105);

	var Column = React.createClass({
	    displayName: 'Column',

	    propTypes: {
	        children: React.PropTypes.node,
	        // oneOf(SIZES): React.PropTypes.number,
	        offset: React.PropTypes.number
	    },

	    render: function render() {
	        var _this = this;

	        var _props = this.props,
	            offset = _props.offset,
	            children = _props.children;


	        var className = classNames(SIZES.reduce(function (list, size) {
	            var col = _this.props[size];

	            if (col) {
	                list.push(['col', size, col].join('-'));
	            }
	            if (col && offset) {
	                list.push(['col', size, 'offset', offset].join('-'));
	            }

	            return list;
	        }, []));

	        return React.createElement(
	            'div',
	            { className: className },
	            children
	        );
	    }
	});

	module.exports = Row;
	module.exports.Container = Container;
	module.exports.Col = Column;

/***/ },

/***/ 118:
/***/ function(module, exports, __webpack_require__) {

	"use strict";

	var React = __webpack_require__(87);

	var PageFooter = React.createClass({
	    displayName: "PageFooter",

	    propTypes: {
	        children: React.PropTypes.node
	    },

	    render: function render() {
	        return React.createElement(
	            "div",
	            { className: "gb-page-footer" },
	            this.props.children
	        );
	    }
	});

	module.exports = PageFooter;

/***/ },

/***/ 124:
/***/ function(module, exports, __webpack_require__) {

	"use strict";

	var React = __webpack_require__(87);

	var PageHeader = React.createClass({
	    displayName: "PageHeader",

	    propTypes: {
	        children: React.PropTypes.node
	    },

	    render: function render() {
	        return React.createElement(
	            "div",
	            { className: "gb-page-header" },
	            this.props.children
	        );
	    }
	});

	var Logo = React.createClass({
	    displayName: "Logo",

	    propTypes: {
	        href: React.PropTypes.string,
	        src: React.PropTypes.string,
	        children: React.PropTypes.node
	    },

	    render: function render() {
	        var _props = this.props,
	            href = _props.href,
	            src = _props.src;


	        return React.createElement(
	            "a",
	            { href: href, className: "logo pull-left" },
	            React.createElement("img", { src: src }),
	            React.createElement(
	                "h1",
	                null,
	                this.props.children
	            )
	        );
	    }
	});

	module.exports = PageHeader;
	module.exports.Logo = Logo;

/***/ },

/***/ 126:
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var _extends2 = __webpack_require__(106);

	var _extends3 = _interopRequireDefault(_extends2);

	var _objectWithoutProperties2 = __webpack_require__(111);

	var _objectWithoutProperties3 = _interopRequireDefault(_objectWithoutProperties2);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	var React = __webpack_require__(87);
	var classNames = __webpack_require__(102);

	var Icon = __webpack_require__(127);
	var STYLES = __webpack_require__(113);
	var SIZES = __webpack_require__(115);

	var BUTTONS_STYLES = STYLES.concat(['link', 'text-link', 'text-danger', 'text-success', 'text-warning', 'count']);

	var Button = React.createClass({
	    displayName: 'Button',

	    propTypes: {
	        className: React.PropTypes.string,
	        children: React.PropTypes.node,
	        type: React.PropTypes.string,
	        size: React.PropTypes.oneOf(SIZES),
	        style: React.PropTypes.oneOf(BUTTONS_STYLES),
	        // Makes a link button
	        href: React.PropTypes.string,
	        // Form button
	        value: React.PropTypes.oneOfType([React.PropTypes.string, React.PropTypes.bool, React.PropTypes.number]),
	        name: React.PropTypes.string,
	        // For links
	        target: React.PropTypes.string,
	        filled: React.PropTypes.bool,
	        noBorder: React.PropTypes.bool,
	        disabled: React.PropTypes.bool,
	        active: React.PropTypes.bool,
	        block: React.PropTypes.bool,
	        dropdownToggle: React.PropTypes.bool,
	        onClick: React.PropTypes.func,
	        title: React.PropTypes.string,
	        icon: React.PropTypes.string
	    },

	    getInitialState: function getInitialState() {
	        return {
	            clicked: false
	        };
	    },
	    getDefaultProps: function getDefaultProps() {
	        return {
	            style: 'default',
	            size: 'md',
	            type: 'button',
	            filled: false,
	            disabled: false,
	            active: false
	        };
	    },
	    onClick: function onClick(e) {
	        var _this = this;

	        var clicked = this.state.clicked;


	        if (this.props.onClick && !clicked) {
	            this.props.onClick(e);
	        }

	        if (!this.isFormButton()) {
	            return;
	        } else if (clicked) {
	            return this.setState({
	                clicked: false
	            });
	        }

	        // Add this submitting button's value to the form as hidden
	        // input. Only after that do the click.
	        // This fixes issues with PJAX[1] in Firefox[2]
	        // [1]: https://github.com/defunkt/jquery-pjax/pull/295
	        // [2]: http://stackoverflow.com/questions/38277900/formdata-object-does-not-add-submit-type-inputs-from-form-while-on-firefox
	        e.preventDefault();
	        this.setState({
	            clicked: true
	        }, function () {
	            _this.refs.button.click();
	        });
	    },
	    isFormButton: function isFormButton() {
	        var _props = this.props,
	            type = _props.type,
	            name = _props.name;

	        return type === 'submit' && name;
	    },
	    render: function render() {
	        var clicked = this.state.clicked;
	        var _props2 = this.props,
	            title = _props2.title,
	            icon = _props2.icon,
	            filled = _props2.filled,
	            block = _props2.block,
	            noBorder = _props2.noBorder,
	            active = _props2.active,
	            dropdownToggle = _props2.dropdownToggle,
	            style = _props2.style,
	            size = _props2.size,
	            className = _props2.className,
	            children = _props2.children,
	            name = _props2.name,
	            value = _props2.value,
	            props = (0, _objectWithoutProperties3.default)(_props2, ['title', 'icon', 'filled', 'block', 'noBorder', 'active', 'dropdownToggle', 'style', 'size', 'className', 'children', 'name', 'value']);


	        var inner = icon ? React.createElement(Icon, { className: icon }) : '';

	        props.className = classNames('btn', 'btn-' + style, 'btn-' + size, className, {
	            'btn-fill': filled,
	            'btn-block': block,
	            'btn-noborder': noBorder,
	            active: active,
	            'dropdown-toggle': dropdownToggle,
	            'tooltipped': Boolean(title)
	        });
	        props['aria-label'] = title;
	        props.role = 'button';
	        props.onClick = this.onClick;

	        var input = void 0;

	        if (clicked && this.isFormButton()) {
	            input = React.createElement('input', { type: 'hidden', name: name, value: value });
	        }

	        if (props.href) {
	            delete props.type;
	            return React.createElement(
	                'a',
	                props,
	                inner,
	                ' ',
	                children
	            );
	        } else {
	            return React.createElement(
	                'button',
	                (0, _extends3.default)({ ref: 'button' }, props),
	                inner,
	                ' ',
	                children,
	                input
	            );
	        }
	    }
	});

	var ButtonGroup = React.createClass({
	    displayName: 'ButtonGroup',

	    propTypes: {
	        className: React.PropTypes.string,
	        children: React.PropTypes.node,
	        pull: React.PropTypes.string,
	        block: React.PropTypes.bool
	    },

	    render: function render() {
	        var _props3 = this.props,
	            className = _props3.className,
	            pull = _props3.pull,
	            children = _props3.children,
	            block = _props3.block;


	        className = classNames('btn-group', className, pull ? 'pull-' + pull : '', {
	            'btn-group-block': block
	        });

	        return React.createElement(
	            'div',
	            { className: className },
	            children
	        );
	    }
	});

	var ButtonToolbar = React.createClass({
	    displayName: 'ButtonToolbar',

	    propTypes: {
	        className: React.PropTypes.string,
	        children: React.PropTypes.node
	    },

	    render: function render() {
	        return React.createElement(
	            'div',
	            { className: 'btn-toolbar ' + (this.props.className || '') },
	            this.props.children
	        );
	    }
	});

	var ButtonCaret = React.createClass({
	    displayName: 'ButtonCaret',
	    render: function render() {
	        return React.createElement('span', { className: 'caret' });
	    }
	});

	var ButtonTextExpander = React.createClass({
	    displayName: 'ButtonTextExpander',

	    propTypes: {
	        onClick: React.PropTypes.func
	    },

	    onClick: function onClick(e) {
	        if (this.props.onClick) {
	            this.props.onClick();
	        }
	    },
	    render: function render() {
	        return React.createElement(
	            'span',
	            { className: 'hidden-text-expander' },
	            React.createElement(
	                'button',
	                { type: 'button', className: 'ellipsis-expander', onClick: this.onClick },
	                '\u2026'
	            )
	        );
	    }
	});

	module.exports = Button;
	module.exports.Group = ButtonGroup;
	module.exports.Toolbar = ButtonToolbar;
	module.exports.Caret = ButtonCaret;
	module.exports.TextExpander = ButtonTextExpander;
	module.exports.STYLES = BUTTONS_STYLES;

/***/ },

/***/ 127:
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var React = __webpack_require__(87);
	var classNames = __webpack_require__(102);

	var Icon = React.createClass({
	    displayName: 'Icon',

	    propTypes: {
	        // Icon of the icon in the collection
	        id: React.PropTypes.string,
	        // Type of collection
	        type: React.PropTypes.string,
	        // Extra className
	        className: React.PropTypes.string,
	        // Is the icon spinning?
	        spin: React.PropTypes.bool
	    },

	    getDefaultProps: function getDefaultProps() {
	        return {
	            type: 'octicon',
	            spin: false
	        };
	    },
	    render: function render() {
	        var _props = this.props,
	            type = _props.type,
	            id = _props.id,
	            className = _props.className,
	            spin = _props.spin;


	        className = classNames(type + ' ' + type + '-' + id, className, {
	            'icon-spin': spin
	        });

	        return React.createElement('i', { className: className });
	    }
	});

	module.exports = Icon;

/***/ },

/***/ 490:
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var _extends2 = __webpack_require__(106);

	var _extends3 = _interopRequireDefault(_extends2);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	var React = __webpack_require__(87);
	var classNames = __webpack_require__(102);

	var SIZES = __webpack_require__(115);

	var Input = React.createClass({
	    displayName: 'Input',

	    propTypes: {
	        className: React.PropTypes.string,
	        onChange: React.PropTypes.func,
	        onFocus: React.PropTypes.func,
	        onBlur: React.PropTypes.func,
	        onPaste: React.PropTypes.func,
	        onKeyDown: React.PropTypes.func,
	        onClick: React.PropTypes.func,
	        name: React.PropTypes.string,
	        type: React.PropTypes.string,
	        placeholder: React.PropTypes.string,
	        disabled: React.PropTypes.bool,
	        readOnly: React.PropTypes.bool,
	        autoFocus: React.PropTypes.bool,
	        size: React.PropTypes.oneOf(SIZES),
	        defaultValue: React.PropTypes.string,
	        value: React.PropTypes.oneOfType([React.PropTypes.string, React.PropTypes.bool])
	    },

	    /*
	        APIs for parent component
	     */
	    focus: function focus() {
	        this.refs.input.focus();
	    },
	    blur: function blur() {
	        this.refs.input.blur();
	    },
	    getDefaultProps: function getDefaultProps() {
	        return {
	            type: 'text',
	            size: SIZES[0]
	        };
	    },
	    onChange: function onChange(e) {
	        if (this.props.onChange) {
	            this.props.onChange(e);
	        }
	    },
	    render: function render() {
	        var _props = this.props,
	            onPaste = _props.onPaste,
	            onBlur = _props.onBlur,
	            onFocus = _props.onFocus,
	            onKeyDown = _props.onKeyDown,
	            onClick = _props.onClick,
	            value = _props.value,
	            readOnly = _props.readOnly,
	            defaultValue = _props.defaultValue,
	            size = _props.size,
	            autoFocus = _props.autoFocus,
	            placeholder = _props.placeholder,
	            type = _props.type,
	            name = _props.name,
	            disabled = _props.disabled;


	        var className = classNames('form-control', 'input-' + size, this.props.className);

	        return React.createElement('input', { ref: 'input',
	            type: type, autoFocus: autoFocus,
	            className: className, disabled: disabled, readOnly: readOnly,
	            name: name, value: value, defaultValue: defaultValue,
	            placeholder: placeholder,
	            onFocus: onFocus,
	            onBlur: onBlur,
	            onKeyDown: onKeyDown,
	            onClick: onClick,
	            onPaste: onPaste,
	            onChange: this.onChange
	        });
	    }
	});

	/**
	 * Create a style of alert
	 * @param {String} style
	 * @return {React.Component}
	 */
	function createInputType(type) {
	    return React.createClass({
	        displayName: Input.displayName + type,
	        render: function render() {
	            return React.createElement(Input, (0, _extends3.default)({}, this.props, { type: type.toLowerCase() }));
	        }
	    });
	}

	var InputGroup = React.createClass({
	    displayName: 'InputGroup',

	    propTypes: {
	        children: React.PropTypes.node,
	        className: React.PropTypes.string
	    },

	    render: function render() {
	        var className = classNames('input-group', this.props.className || []);
	        return React.createElement(
	            'div',
	            { className: className },
	            this.props.children
	        );
	    }
	});

	var InputGroupAddon = React.createClass({
	    displayName: 'InputGroupAddon',

	    propTypes: {
	        children: React.PropTypes.node
	    },

	    render: function render() {
	        return React.createElement(
	            'span',
	            (0, _extends3.default)({}, this.props, { className: 'input-group-addon' }),
	            this.props.children
	        );
	    }
	});

	module.exports = Input;
	module.exports.Email = createInputType('Email');
	module.exports.Password = createInputType('Password');
	module.exports.Group = InputGroup;
	module.exports.GroupAddon = InputGroupAddon;

/***/ },

/***/ 503:
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var _extends2 = __webpack_require__(106);

	var _extends3 = _interopRequireDefault(_extends2);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	var React = __webpack_require__(87);
	var classNames = __webpack_require__(102);

	var Form = React.createClass({
	    displayName: 'Form',

	    propTypes: {
	        children: React.PropTypes.node
	    },

	    submit: function submit() {
	        this.refs.form.submit();
	    },
	    render: function render() {
	        return React.createElement(
	            'form',
	            (0, _extends3.default)({ ref: 'form' }, this.props),
	            this.props.children
	        );
	    }
	});

	var FormGroup = React.createClass({
	    displayName: 'FormGroup',

	    propTypes: {
	        error: React.PropTypes.bool,
	        className: React.PropTypes.string,
	        children: React.PropTypes.node
	    },

	    getDefaulProps: function getDefaulProps() {
	        return {
	            error: false
	        };
	    },
	    render: function render() {
	        var className = classNames('form-group', {
	            'has-error': this.props.error
	        }, this.props.className);

	        return React.createElement(
	            'div',
	            { className: className },
	            this.props.children
	        );
	    }
	});

	var FormHelpBlock = React.createClass({
	    displayName: 'FormHelpBlock',

	    propTypes: {
	        children: React.PropTypes.node
	    },

	    render: function render() {
	        return React.createElement(
	            'p',
	            { className: 'help-block' },
	            this.props.children
	        );
	    }
	});

	module.exports = Form;
	module.exports.Group = FormGroup;
	module.exports.HelpBlock = FormHelpBlock;

/***/ },

/***/ 504:
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var React = __webpack_require__(87);
	var classNames = __webpack_require__(102);

	var SIZES = __webpack_require__(115);
	var Button = __webpack_require__(126);
	var Input = __webpack_require__(490);
	var Backdrop = __webpack_require__(499);

	var DEFAULT_SEARCH_PLACEHOLDER = 'Search';

	var itemShape = React.PropTypes.oneOfType([React.PropTypes.string, React.PropTypes.object]);

	var groupShape = React.PropTypes.shape({
	    label: React.PropTypes.string,
	    options: React.PropTypes.arrayOf(itemShape)
	});

	/**
	 * Default filter for select
	 */
	function defaultFilter(query, item, i) {
	    return true;
	}

	/**
	 * Default render for options
	 */
	function defaultComponent(_ref) {
	    var option = _ref.option;

	    return React.createElement(
	        'span',
	        null,
	        option
	    );
	}
	defaultComponent.propTypes = {
	    option: itemShape
	};

	/**
	 * Default render to string for input
	 */
	function defaultRenderToString(item, i) {
	    return String(item);
	}

	/**
	 * Interractive select for forms
	 *
	 * It renders as a normal select on server and has a custom UI on browser (with search, images support).
	 *
	 * <Select name="test">
	 *     <Select.Option key="en">English</Select.Option>
	 *     <Select.Option key="fr">French</Select.Option>
	 * </Select>
	 */
	var Select = React.createClass({
	    displayName: 'Select',

	    propTypes: {
	        // Current value of the select
	        value: React.PropTypes.oneOfType([itemShape, React.PropTypes.arrayOf(itemShape)]),

	        // List of items to display
	        groups: React.PropTypes.arrayOf(groupShape),
	        options: React.PropTypes.arrayOf(itemShape),

	        // Function to render the option to a string or element
	        component: React.PropTypes.func,

	        // Function to render the selected option in the button
	        // Defaults to "renderOption"
	        componentSelection: React.PropTypes.func,

	        // Function to output an option as a string
	        // Defaults to a string representation, you have to provide your own value
	        // when using a custom option renderer
	        renderToString: React.PropTypes.func,

	        // Function to filter an element
	        filter: React.PropTypes.func,

	        // Optional callback when value changed
	        onChange: React.PropTypes.func,

	        // Name when using server posting
	        name: React.PropTypes.string,

	        // Text to display when no value is set
	        placeholder: React.PropTypes.string,
	        searchPlaceholder: React.PropTypes.string,

	        // Delimiter for multiple values
	        delimiter: React.PropTypes.string,

	        // Prevent selection
	        disabled: React.PropTypes.bool,

	        // Display the search filter?
	        search: React.PropTypes.bool,

	        // Accept multiple values
	        multiple: React.PropTypes.bool,

	        // Size of the select to display
	        size: React.PropTypes.oneOf(SIZES),

	        // Take the whole width
	        block: React.PropTypes.bool
	    },

	    getDefaultProps: function getDefaultProps() {
	        return {
	            disabled: false,
	            search: true,
	            delimiter: ',',
	            size: SIZES[0],
	            multiple: false,
	            block: false,
	            filter: defaultFilter,
	            component: defaultComponent,
	            renderToString: defaultRenderToString,
	            searchPlaceholder: DEFAULT_SEARCH_PLACEHOLDER,
	            placeholder: 'Select'
	        };
	    },
	    getInitialState: function getInitialState() {
	        return {
	            value: this.props.value,
	            query: '',
	            opened: false,
	            groups: this.propsToGroups(this.props)
	        };
	    },
	    componentWillReceiveProps: function componentWillReceiveProps(newProps) {
	        this.setState({
	            value: newProps.value,
	            groups: this.propsToGroups(newProps),
	            opened: newProps.disabled ? false : this.state.opened
	        });
	    },


	    /**
	     * Create list of groups from props
	     * @param {Object} props
	     * @return {Array<groupShape>}
	     */
	    propsToGroups: function propsToGroups(props) {
	        var _props = this.props,
	            options = _props.options,
	            groups = _props.groups;


	        if (groups) {
	            return groups;
	        }

	        return [{ options: options }];
	    },


	    /**
	     * Search query changed
	     */
	    onSearchChanged: function onSearchChanged(e) {
	        this.setState({
	            query: e.target.value
	        });
	    },


	    /**
	     * Toggle (close/open) the select
	     */
	    onToggle: function onToggle() {
	        this.setState({
	            opened: !this.state.opened
	        });
	    },


	    /**
	     * Close the select
	     */
	    close: function close() {
	        this.setState({
	            opened: false
	        });
	    },


	    /**
	     * Open the select
	     */
	    open: function open() {
	        this.setState({
	            opened: false
	        });
	    },


	    /**
	     * Focus the search if open
	     */
	    focusOnOpen: function focusOnOpen() {
	        if (this.state.opened) {
	            this.focusSearch();
	        }
	    },
	    componentDidUpdate: function componentDidUpdate() {
	        this.focusOnOpen();
	    },
	    componentDidMount: function componentDidMount() {
	        this.focusOnOpen();
	    },


	    /**
	     * Toggle an option
	     */
	    onToggleOption: function onToggleOption(addValue, e) {
	        if (e) {
	            e.preventDefault();
	        }

	        var _state = this.state,
	            value = _state.value,
	            multiple = _state.multiple;
	        var onChange = this.props.onChange;

	        var newState = void 0,
	            newValue = void 0;

	        if (multiple) {
	            newValue = value;

	            // Add to selection if not yet selected
	            if (!this.hasValue(addValue)) {
	                newValue = value.concat([addValue]);
	            } else if (value.length > 1) {
	                // Unselect if many options are selected
	                newValue.splice(newValue.indexOf(addValue), 1);
	            }

	            newState = {
	                value: newValue
	            };
	        } else {
	            newValue = addValue;

	            newState = {
	                value: addValue,
	                opened: false
	            };
	        }

	        this.setState(newState, function () {
	            if (onChange) {
	                onChange(newValue);
	            }
	        });
	    },


	    /**
	     * Get current value as a string (for hidden input)
	     * @return {String}
	     */
	    getStringValue: function getStringValue() {
	        var renderToString = this.props.renderToString;
	        var value = this.state.value;


	        if (!value) {
	            return '';
	        }

	        if (!this.props.multiple) {
	            return renderToString(value);
	        } else {
	            return value.map(renderToString).join(this.props.delimiter);
	        }
	    },


	    /**
	     * Check if a value is selected
	     * @param {String} value
	     * @return {Boolean}
	     */
	    hasValue: function hasValue(value) {
	        var currentValue = this.state.value;

	        if (!this.props.multiple) {
	            return currentValue === value;
	        } else {
	            return currentValue.indexOf(value) >= 0;
	        }
	    },


	    /**
	     * Focus the search input
	     */
	    focusSearch: function focusSearch() {
	        var searchInput = this.refs.searchInput;

	        if (!searchInput) {
	            return;
	        }

	        searchInput.focus();
	    },


	    /**
	     * Render button to open select
	     */
	    renderButton: function renderButton() {
	        var _props2 = this.props,
	            disabled = _props2.disabled,
	            block = _props2.block,
	            multiple = _props2.multiple,
	            placeholder = _props2.placeholder;
	        var _state2 = this.state,
	            value = _state2.value,
	            opened = _state2.opened;

	        var ComponentSelection = this.props.componentSelection || this.props.component;

	        var inner = void 0;

	        if (value) {
	            var values = multiple ? value : [value];
	            inner = React.createElement(
	                'span',
	                { className: 'SelectSelections' },
	                values.map(function (val, i) {
	                    return React.createElement(
	                        'span',
	                        { key: i, className: 'SelectSelection' },
	                        React.createElement(ComponentSelection, { option: val, index: i })
	                    );
	                })
	            );
	        } else {
	            inner = React.createElement(
	                'span',
	                { className: 'SelectPlaceholder' },
	                placeholder
	            );
	        }

	        return React.createElement(
	            Button,
	            { size: this.props.size, block: block, disabled: disabled, active: opened, onClick: this.onToggle },
	            inner,
	            ' ',
	            React.createElement(Button.Caret, null)
	        );
	    },


	    /**
	     * Render button to open select
	     */
	    renderSearch: function renderSearch() {
	        var query = this.state.query;


	        return React.createElement(
	            'div',
	            { className: 'SelectSearch' },
	            React.createElement(Input, { ref: 'searchInput',
	                value: query,
	                onChange: this.onSearchChanged,
	                placeholder: this.props.placeholder
	            })
	        );
	    },


	    /**
	     * Render the options selector
	     */
	    renderGroup: function renderGroup(group, index) {
	        var query = this.state.query;
	        var filter = this.props.filter;

	        var Component = this.props.component;
	        var count = 0;

	        var options = group.options.map(function (item, i) {
	            var _this = this;

	            if (!filter(query, item, i)) {
	                return '';
	            }

	            count++;

	            return React.createElement(
	                'div',
	                {
	                    key: i,
	                    className: classNames('SelectOption', { active: this.hasValue(item) }),
	                    onClick: function onClick(e) {
	                        return _this.onToggleOption(item);
	                    }
	                },
	                React.createElement(Component, { option: item, index: i })
	            );
	        }, this);

	        // Don't display empty groups (when filtered)
	        if (count === 0) {
	            return '';
	        }

	        return React.createElement(
	            'div',
	            { key: index, className: 'SelectOptGroup' },
	            group.label ? React.createElement(
	                'div',
	                { className: 'GroupLabel' },
	                group.label
	            ) : '',
	            React.createElement(
	                'div',
	                { className: 'GroupOptions' },
	                options
	            )
	        );
	    },


	    /**
	     * Render the groups
	     */
	    renderGroups: function renderGroups() {
	        var _state3 = this.state,
	            opened = _state3.opened,
	            groups = _state3.groups;
	        var search = this.props.search;


	        var className = classNames('SelectContainer', {
	            'open': opened
	        });

	        return React.createElement(
	            'div',
	            { className: className },
	            search ? this.renderSearch() : '',
	            React.createElement(
	                'div',
	                { className: 'SelectGroups' },
	                groups.map(this.renderGroup)
	            )
	        );
	    },
	    render: function render() {
	        var _props3 = this.props,
	            name = _props3.name,
	            block = _props3.block;
	        var opened = this.state.opened;


	        var className = classNames('SelectFormControl', {
	            block: block
	        });

	        return React.createElement(
	            'div',
	            { className: className, onClick: function onClick(e) {
	                    return e.stopPropagation();
	                } },
	            React.createElement('input', { type: 'hidden', name: name, value: this.getStringValue() }),
	            this.renderButton(),
	            opened ? React.createElement(
	                Backdrop,
	                { onClose: this.close },
	                this.renderGroups()
	            ) : ''
	        );
	    }
	});

	module.exports = Select;

/***/ },

/***/ 506:
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var React = __webpack_require__(87);
	var classNames = __webpack_require__(102);

	var SIZES = __webpack_require__(115);

	var Textarea = React.createClass({
	    displayName: 'Textarea',

	    propTypes: {
	        onChange: React.PropTypes.func,
	        name: React.PropTypes.string,
	        className: React.PropTypes.string,
	        placeholder: React.PropTypes.string,
	        disabled: React.PropTypes.bool,
	        autoFocus: React.PropTypes.bool,
	        size: React.PropTypes.oneOf(SIZES),
	        rows: React.PropTypes.number,
	        maxLength: React.PropTypes.number,
	        defaultValue: React.PropTypes.string,
	        value: React.PropTypes.oneOfType([React.PropTypes.string, React.PropTypes.bool])
	    },

	    /*
	        APIs for parent component
	     */
	    focus: function focus() {
	        this.refs.textarea.focus();
	    },
	    blur: function blur() {
	        this.refs.textarea.blur();
	    },
	    getDefaultProps: function getDefaultProps() {
	        return {
	            size: SIZES[0],
	            rows: 3
	        };
	    },
	    onChange: function onChange(e) {
	        if (this.props.onChange) {
	            this.props.onChange(e);
	        }
	    },
	    render: function render() {
	        var _props = this.props,
	            disabled = _props.disabled,
	            name = _props.name,
	            placeholder = _props.placeholder,
	            size = _props.size,
	            rows = _props.rows,
	            autoFocus = _props.autoFocus,
	            value = _props.value,
	            defaultValue = _props.defaultValue,
	            maxLength = _props.maxLength;


	        var className = classNames('form-control', 'input-' + size, this.props.className);

	        return React.createElement('textarea', { ref: 'textarea',
	            className: className, rows: rows, maxLength: maxLength,
	            autoFocus: autoFocus, disabled: disabled,
	            name: name, value: value, defaultValue: defaultValue,
	            placeholder: placeholder, onChange: this.onChange });
	    }
	});

	module.exports = Textarea;

/***/ }

})