webpackHotUpdate(18,{

/***/ 112:
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var React = __webpack_require__(87);
	var classNames = __webpack_require__(102);

	var STYLES = __webpack_require__(113);

	var Panel = React.createClass({
	    displayName: 'Panel',

	    propTypes: {
	        style: React.PropTypes.oneOf(STYLES),
	        children: React.PropTypes.node
	    },

	    getDefaultProps: function getDefaultProps() {
	        return {
	            style: STYLES[0]
	        };
	    },
	    render: function render() {
	        var style = this.props.style;

	        return React.createElement(
	            'div',
	            { className: classNames('panel', 'panel-' + style) },
	            this.props.children
	        );
	    }
	});

	var PanelHeading = React.createClass({
	    displayName: 'PanelHeading',

	    propTypes: {
	        title: React.PropTypes.string,
	        children: React.PropTypes.node
	    },

	    render: function render() {
	        var title = this.props.title;
	        var inner = '';

	        if (title) {
	            inner = React.createElement(
	                PanelTitle,
	                null,
	                title
	            );
	        }

	        return React.createElement(
	            'div',
	            { className: 'panel-heading' },
	            inner,
	            this.props.children
	        );
	    }
	});

	var PanelTitle = React.createClass({
	    displayName: 'PanelTitle',

	    propTypes: {
	        children: React.PropTypes.node
	    },

	    render: function render() {
	        return React.createElement(
	            'h3',
	            { className: 'panel-title' },
	            this.props.children
	        );
	    }
	});

	var PanelToolbar = React.createClass({
	    displayName: 'PanelToolbar',

	    propTypes: {
	        children: React.PropTypes.node
	    },

	    render: function render() {
	        return React.createElement(
	            'div',
	            { className: 'panel-toolbar' },
	            this.props.children
	        );
	    }
	});

	var PanelBody = React.createClass({
	    displayName: 'PanelBody',

	    propTypes: {
	        children: React.PropTypes.node
	    },

	    render: function render() {
	        return React.createElement(
	            'div',
	            { className: 'panel-body' },
	            this.props.children
	        );
	    }
	});

	var PanelFooter = React.createClass({
	    displayName: 'PanelFooter',

	    propTypes: {
	        children: React.PropTypes.node
	    },

	    render: function render() {
	        return React.createElement(
	            'div',
	            { className: 'panel-footer' },
	            this.props.children
	        );
	    }
	});

	module.exports = Panel;
	module.exports.Heading = PanelHeading;
	module.exports.Title = PanelTitle;
	module.exports.Body = PanelBody;
	module.exports.Footer = PanelFooter;
	module.exports.Toolbar = PanelToolbar;

/***/ },

/***/ 114:
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var React = __webpack_require__(87);
	var classNames = __webpack_require__(102);
	var SIZES = __webpack_require__(115);

	var Row = React.createClass({
	    displayName: 'Row',

	    propTypes: {
	        children: React.PropTypes.node
	    },

	    render: function render() {
	        return React.createElement(
	            'div',
	            { className: 'row' },
	            this.props.children
	        );
	    }
	});

	var Container = __webpack_require__(105);

	var Column = React.createClass({
	    displayName: 'Column',

	    propTypes: {
	        children: React.PropTypes.node,
	        // oneOf(SIZES): React.PropTypes.number,
	        offset: React.PropTypes.number
	    },

	    render: function render() {
	        var _this = this;

	        var _props = this.props,
	            offset = _props.offset,
	            children = _props.children;


	        var className = classNames(SIZES.reduce(function (list, size) {
	            var col = _this.props[size];

	            if (col) {
	                list.push(['col', size, col].join('-'));
	            }
	            if (col && offset) {
	                list.push(['col', size, 'offset', offset].join('-'));
	            }

	            return list;
	        }, []));

	        return React.createElement(
	            'div',
	            { className: className },
	            children
	        );
	    }
	});

	module.exports = Row;
	module.exports.Container = Container;
	module.exports.Col = Column;

/***/ },

/***/ 118:
/***/ function(module, exports, __webpack_require__) {

	"use strict";

	var React = __webpack_require__(87);

	var PageFooter = React.createClass({
	    displayName: "PageFooter",

	    propTypes: {
	        children: React.PropTypes.node
	    },

	    render: function render() {
	        return React.createElement(
	            "div",
	            { className: "gb-page-footer" },
	            this.props.children
	        );
	    }
	});

	module.exports = PageFooter;

/***/ },

/***/ 124:
/***/ function(module, exports, __webpack_require__) {

	"use strict";

	var React = __webpack_require__(87);

	var PageHeader = React.createClass({
	    displayName: "PageHeader",

	    propTypes: {
	        children: React.PropTypes.node
	    },

	    render: function render() {
	        return React.createElement(
	            "div",
	            { className: "gb-page-header" },
	            this.props.children
	        );
	    }
	});

	var Logo = React.createClass({
	    displayName: "Logo",

	    propTypes: {
	        href: React.PropTypes.string,
	        src: React.PropTypes.string,
	        children: React.PropTypes.node
	    },

	    render: function render() {
	        var _props = this.props,
	            href = _props.href,
	            src = _props.src;


	        return React.createElement(
	            "a",
	            { href: href, className: "logo pull-left" },
	            React.createElement("img", { src: src }),
	            React.createElement(
	                "h1",
	                null,
	                this.props.children
	            )
	        );
	    }
	});

	module.exports = PageHeader;
	module.exports.Logo = Logo;

/***/ },

/***/ 126:
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var _extends2 = __webpack_require__(106);

	var _extends3 = _interopRequireDefault(_extends2);

	var _objectWithoutProperties2 = __webpack_require__(111);

	var _objectWithoutProperties3 = _interopRequireDefault(_objectWithoutProperties2);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	var React = __webpack_require__(87);
	var classNames = __webpack_require__(102);

	var Icon = __webpack_require__(127);
	var STYLES = __webpack_require__(113);
	var SIZES = __webpack_require__(115);

	var BUTTONS_STYLES = STYLES.concat(['link', 'text-link', 'text-danger', 'text-success', 'text-warning', 'count']);

	var Button = React.createClass({
	    displayName: 'Button',

	    propTypes: {
	        className: React.PropTypes.string,
	        children: React.PropTypes.node,
	        type: React.PropTypes.string,
	        size: React.PropTypes.oneOf(SIZES),
	        style: React.PropTypes.oneOf(BUTTONS_STYLES),
	        // Makes a link button
	        href: React.PropTypes.string,
	        // Form button
	        value: React.PropTypes.oneOfType([React.PropTypes.string, React.PropTypes.bool, React.PropTypes.number]),
	        name: React.PropTypes.string,
	        // For links
	        target: React.PropTypes.string,
	        filled: React.PropTypes.bool,
	        noBorder: React.PropTypes.bool,
	        disabled: React.PropTypes.bool,
	        active: React.PropTypes.bool,
	        block: React.PropTypes.bool,
	        dropdownToggle: React.PropTypes.bool,
	        onClick: React.PropTypes.func,
	        title: React.PropTypes.string,
	        icon: React.PropTypes.string
	    },

	    getInitialState: function getInitialState() {
	        return {
	            clicked: false
	        };
	    },
	    getDefaultProps: function getDefaultProps() {
	        return {
	            style: 'default',
	            size: 'md',
	            type: 'button',
	            filled: false,
	            disabled: false,
	            active: false
	        };
	    },
	    onClick: function onClick(e) {
	        var _this = this;

	        var clicked = this.state.clicked;


	        if (this.props.onClick && !clicked) {
	            this.props.onClick(e);
	        }

	        if (!this.isFormButton()) {
	            return;
	        } else if (clicked) {
	            return this.setState({
	                clicked: false
	            });
	        }

	        // Add this submitting button's value to the form as hidden
	        // input. Only after that do the click.
	        // This fixes issues with PJAX[1] in Firefox[2]
	        // [1]: https://github.com/defunkt/jquery-pjax/pull/295
	        // [2]: http://stackoverflow.com/questions/38277900/formdata-object-does-not-add-submit-type-inputs-from-form-while-on-firefox
	        e.preventDefault();
	        this.setState({
	            clicked: true
	        }, function () {
	            _this.refs.button.click();
	        });
	    },
	    isFormButton: function isFormButton() {
	        var _props = this.props,
	            type = _props.type,
	            name = _props.name;

	        return type === 'submit' && name;
	    },
	    render: function render() {
	        var clicked = this.state.clicked;
	        var _props2 = this.props,
	            title = _props2.title,
	            icon = _props2.icon,
	            filled = _props2.filled,
	            block = _props2.block,
	            noBorder = _props2.noBorder,
	            active = _props2.active,
	            dropdownToggle = _props2.dropdownToggle,
	            style = _props2.style,
	            size = _props2.size,
	            className = _props2.className,
	            children = _props2.children,
	            name = _props2.name,
	            value = _props2.value,
	            props = (0, _objectWithoutProperties3.default)(_props2, ['title', 'icon', 'filled', 'block', 'noBorder', 'active', 'dropdownToggle', 'style', 'size', 'className', 'children', 'name', 'value']);


	        var inner = icon ? React.createElement(Icon, { className: icon }) : '';

	        props.className = classNames('btn', 'btn-' + style, 'btn-' + size, className, {
	            'btn-fill': filled,
	            'btn-block': block,
	            'btn-noborder': noBorder,
	            active: active,
	            'dropdown-toggle': dropdownToggle,
	            'tooltipped': Boolean(title)
	        });
	        props['aria-label'] = title;
	        props.role = 'button';
	        props.onClick = this.onClick;

	        var input = void 0;

	        if (clicked && this.isFormButton()) {
	            input = React.createElement('input', { type: 'hidden', name: name, value: value });
	        }

	        if (props.href) {
	            delete props.type;
	            return React.createElement(
	                'a',
	                props,
	                inner,
	                ' ',
	                children
	            );
	        } else {
	            return React.createElement(
	                'button',
	                (0, _extends3.default)({ ref: 'button' }, props),
	                inner,
	                ' ',
	                children,
	                input
	            );
	        }
	    }
	});

	var ButtonGroup = React.createClass({
	    displayName: 'ButtonGroup',

	    propTypes: {
	        className: React.PropTypes.string,
	        children: React.PropTypes.node,
	        pull: React.PropTypes.string,
	        block: React.PropTypes.bool
	    },

	    render: function render() {
	        var _props3 = this.props,
	            className = _props3.className,
	            pull = _props3.pull,
	            children = _props3.children,
	            block = _props3.block;


	        className = classNames('btn-group', className, pull ? 'pull-' + pull : '', {
	            'btn-group-block': block
	        });

	        return React.createElement(
	            'div',
	            { className: className },
	            children
	        );
	    }
	});

	var ButtonToolbar = React.createClass({
	    displayName: 'ButtonToolbar',

	    propTypes: {
	        className: React.PropTypes.string,
	        children: React.PropTypes.node
	    },

	    render: function render() {
	        return React.createElement(
	            'div',
	            { className: 'btn-toolbar ' + (this.props.className || '') },
	            this.props.children
	        );
	    }
	});

	var ButtonCaret = React.createClass({
	    displayName: 'ButtonCaret',
	    render: function render() {
	        return React.createElement('span', { className: 'caret' });
	    }
	});

	var ButtonTextExpander = React.createClass({
	    displayName: 'ButtonTextExpander',

	    propTypes: {
	        onClick: React.PropTypes.func
	    },

	    onClick: function onClick(e) {
	        if (this.props.onClick) {
	            this.props.onClick();
	        }
	    },
	    render: function render() {
	        return React.createElement(
	            'span',
	            { className: 'hidden-text-expander' },
	            React.createElement(
	                'button',
	                { type: 'button', className: 'ellipsis-expander', onClick: this.onClick },
	                '\u2026'
	            )
	        );
	    }
	});

	module.exports = Button;
	module.exports.Group = ButtonGroup;
	module.exports.Toolbar = ButtonToolbar;
	module.exports.Caret = ButtonCaret;
	module.exports.TextExpander = ButtonTextExpander;
	module.exports.STYLES = BUTTONS_STYLES;

/***/ },

/***/ 127:
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var React = __webpack_require__(87);
	var classNames = __webpack_require__(102);

	var Icon = React.createClass({
	    displayName: 'Icon',

	    propTypes: {
	        // Icon of the icon in the collection
	        id: React.PropTypes.string,
	        // Type of collection
	        type: React.PropTypes.string,
	        // Extra className
	        className: React.PropTypes.string,
	        // Is the icon spinning?
	        spin: React.PropTypes.bool
	    },

	    getDefaultProps: function getDefaultProps() {
	        return {
	            type: 'octicon',
	            spin: false
	        };
	    },
	    render: function render() {
	        var _props = this.props,
	            type = _props.type,
	            id = _props.id,
	            className = _props.className,
	            spin = _props.spin;


	        className = classNames(type + ' ' + type + '-' + id, className, {
	            'icon-spin': spin
	        });

	        return React.createElement('i', { className: className });
	    }
	});

	module.exports = Icon;

/***/ },

/***/ 490:
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var _extends2 = __webpack_require__(106);

	var _extends3 = _interopRequireDefault(_extends2);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	var React = __webpack_require__(87);
	var classNames = __webpack_require__(102);

	var SIZES = __webpack_require__(115);

	var Input = React.createClass({
	    displayName: 'Input',

	    propTypes: {
	        className: React.PropTypes.string,
	        onChange: React.PropTypes.func,
	        onFocus: React.PropTypes.func,
	        onBlur: React.PropTypes.func,
	        onPaste: React.PropTypes.func,
	        onKeyDown: React.PropTypes.func,
	        onClick: React.PropTypes.func,
	        name: React.PropTypes.string,
	        type: React.PropTypes.string,
	        placeholder: React.PropTypes.string,
	        disabled: React.PropTypes.bool,
	        readOnly: React.PropTypes.bool,
	        autoFocus: React.PropTypes.bool,
	        size: React.PropTypes.oneOf(SIZES),
	        defaultValue: React.PropTypes.string,
	        value: React.PropTypes.oneOfType([React.PropTypes.string, React.PropTypes.bool])
	    },

	    /*
	        APIs for parent component
	     */
	    focus: function focus() {
	        this.refs.input.focus();
	    },
	    blur: function blur() {
	        this.refs.input.blur();
	    },
	    getDefaultProps: function getDefaultProps() {
	        return {
	            type: 'text',
	            size: SIZES[0]
	        };
	    },
	    onChange: function onChange(e) {
	        if (this.props.onChange) {
	            this.props.onChange(e);
	        }
	    },
	    render: function render() {
	        var _props = this.props,
	            onPaste = _props.onPaste,
	            onBlur = _props.onBlur,
	            onFocus = _props.onFocus,
	            onKeyDown = _props.onKeyDown,
	            onClick = _props.onClick,
	            value = _props.value,
	            readOnly = _props.readOnly,
	            defaultValue = _props.defaultValue,
	            size = _props.size,
	            autoFocus = _props.autoFocus,
	            placeholder = _props.placeholder,
	            type = _props.type,
	            name = _props.name,
	            disabled = _props.disabled;


	        var className = classNames('form-control', 'input-' + size, this.props.className);

	        return React.createElement('input', { ref: 'input',
	            type: type, autoFocus: autoFocus,
	            className: className, disabled: disabled, readOnly: readOnly,
	            name: name, value: value, defaultValue: defaultValue,
	            placeholder: placeholder,
	            onFocus: onFocus,
	            onBlur: onBlur,
	            onKeyDown: onKeyDown,
	            onClick: onClick,
	            onPaste: onPaste,
	            onChange: this.onChange
	        });
	    }
	});

	/**
	 * Create a style of alert
	 * @param {String} style
	 * @return {React.Component}
	 */
	function createInputType(type) {
	    return React.createClass({
	        displayName: Input.displayName + type,
	        render: function render() {
	            return React.createElement(Input, (0, _extends3.default)({}, this.props, { type: type.toLowerCase() }));
	        }
	    });
	}

	var InputGroup = React.createClass({
	    displayName: 'InputGroup',

	    propTypes: {
	        children: React.PropTypes.node,
	        className: React.PropTypes.string
	    },

	    render: function render() {
	        var className = classNames('input-group', this.props.className || []);
	        return React.createElement(
	            'div',
	            { className: className },
	            this.props.children
	        );
	    }
	});

	var InputGroupAddon = React.createClass({
	    displayName: 'InputGroupAddon',

	    propTypes: {
	        children: React.PropTypes.node
	    },

	    render: function render() {
	        return React.createElement(
	            'span',
	            (0, _extends3.default)({}, this.props, { className: 'input-group-addon' }),
	            this.props.children
	        );
	    }
	});

	module.exports = Input;
	module.exports.Email = createInputType('Email');
	module.exports.Password = createInputType('Password');
	module.exports.Group = InputGroup;
	module.exports.GroupAddon = InputGroupAddon;

/***/ },

/***/ 503:
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var _extends2 = __webpack_require__(106);

	var _extends3 = _interopRequireDefault(_extends2);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	var React = __webpack_require__(87);
	var classNames = __webpack_require__(102);

	var Form = React.createClass({
	    displayName: 'Form',

	    propTypes: {
	        children: React.PropTypes.node
	    },

	    submit: function submit() {
	        this.refs.form.submit();
	    },
	    render: function render() {
	        return React.createElement(
	            'form',
	            (0, _extends3.default)({ ref: 'form' }, this.props),
	            this.props.children
	        );
	    }
	});

	var FormGroup = React.createClass({
	    displayName: 'FormGroup',

	    propTypes: {
	        error: React.PropTypes.bool,
	        className: React.PropTypes.string,
	        children: React.PropTypes.node
	    },

	    getDefaulProps: function getDefaulProps() {
	        return {
	            error: false
	        };
	    },
	    render: function render() {
	        var className = classNames('form-group', {
	            'has-error': this.props.error
	        }, this.props.className);

	        return React.createElement(
	            'div',
	            { className: className },
	            this.props.children
	        );
	    }
	});

	var FormHelpBlock = React.createClass({
	    displayName: 'FormHelpBlock',

	    propTypes: {
	        children: React.PropTypes.node
	    },

	    render: function render() {
	        return React.createElement(
	            'p',
	            { className: 'help-block' },
	            this.props.children
	        );
	    }
	});

	module.exports = Form;
	module.exports.Group = FormGroup;
	module.exports.HelpBlock = FormHelpBlock;

/***/ },

/***/ 515:
/***/ function(module, exports, __webpack_require__) {

	"use strict";

	var React = __webpack_require__(87);

	/**
	 * Component to create overviews/intros with a title, description,
	 * metas info (links), and a picture.
	 */
	var Overview = React.createClass({
	    displayName: "Overview",

	    propTypes: {
	        children: React.PropTypes.node
	    },

	    render: function render() {
	        return React.createElement(
	            "div",
	            { className: "overview" },
	            this.props.children
	        );
	    }
	});

	Overview.Title = React.createClass({
	    displayName: "Title",

	    propTypes: {
	        children: React.PropTypes.node
	    },

	    render: function render() {
	        return React.createElement(
	            "h1",
	            { className: "overview-title" },
	            this.props.children
	        );
	    }
	});

	Overview.Note = React.createClass({
	    displayName: "Note",

	    propTypes: {
	        children: React.PropTypes.node
	    },

	    render: function render() {
	        return React.createElement(
	            "p",
	            { className: "overview-note" },
	            this.props.children
	        );
	    }
	});

	Overview.Description = React.createClass({
	    displayName: "Description",

	    propTypes: {
	        children: React.PropTypes.node
	    },

	    render: function render() {
	        return React.createElement(
	            "p",
	            { className: "overview-description" },
	            this.props.children
	        );
	    }
	});

	Overview.Meta = React.createClass({
	    displayName: "Meta",

	    propTypes: {
	        children: React.PropTypes.node
	    },

	    render: function render() {
	        return React.createElement(
	            "div",
	            { className: "overview-meta" },
	            this.props.children
	        );
	    }
	});

	module.exports = Overview;
	// Overview
	// Overview.Title
	// Overview.Description
	// Overview.Meta

/***/ },

/***/ 516:
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var _from = __webpack_require__(517);

	var _from2 = _interopRequireDefault(_from);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	var React = __webpack_require__(87);
	var classNames = __webpack_require__(102);

	var Pagination = React.createClass({
	    displayName: 'Pagination',

	    propTypes: {
	        // Index of current page
	        page: React.PropTypes.number.isRequired,

	        // Total count of pages
	        pages: React.PropTypes.number.isRequired,

	        // Minimum number of pages to list
	        pagesToList: React.PropTypes.number,

	        // Callback when page changed (optional)
	        onChange: React.PropTypes.func,

	        // Current uri
	        getURL: React.PropTypes.func
	    },

	    getDefaultProps: function getDefaultProps() {
	        return {
	            getURL: function getURL(page) {
	                return '?page=' + page;
	            },
	            pagesToList: 5
	        };
	    },


	    /**
	     * Clicked to select a page
	     * @param  {Number} i
	     */
	    onSelectPage: function onSelectPage(i, e) {
	        if (this.props.onChange) {
	            e.preventDefault();
	            return this.props.onChange(i);
	        }
	    },


	    /**
	     * Render a page selector
	     * @param {Number} i
	     * @param {String} text
	     * @return {React.Element}
	     */
	    renderPageItem: function renderPageItem(i, text) {
	        var page = this.props.page;
	        var isActive = i === page;
	        var className = classNames({
	            active: isActive
	        });
	        var uri = this.props.getURL(i);

	        return React.createElement(
	            'li',
	            { key: i, className: className },
	            React.createElement(
	                'a',
	                { href: uri, onClick: this.onSelectPage.bind(this, i) },
	                text || i
	            )
	        );
	    },
	    render: function render() {
	        var page = this.props.page;
	        var pages = this.props.pages;
	        var pagesToList = this.props.pagesToList;

	        if (pages < 2) {
	            return React.createElement('div', null);
	        }

	        if (page < 0) page = 0;
	        if (page >= pages) page = pages - 1;

	        var startRange = Math.max(0, page - pagesToList);
	        var maxRange = pages;
	        var endRange = Math.min(maxRange, page + pagesToList);
	        var pagesRange = (0, _from2.default)(Array(pages)).map(Number.call, Number).slice(startRange, endRange);

	        return React.createElement(
	            'div',
	            { className: 'pagination' },
	            React.createElement(
	                'ul',
	                { className: 'pagination-pages' },
	                startRange === 0 ? '' : this.renderPageItem(0),
	                startRange === 0 ? '' : React.createElement(
	                    'li',
	                    null,
	                    React.createElement(
	                        'span',
	                        { className: 'separator' },
	                        '...'
	                    )
	                ),
	                pagesRange.map(function (i) {
	                    return this.renderPageItem(i);
	                }, this),
	                endRange === maxRange ? '' : React.createElement(
	                    'li',
	                    null,
	                    React.createElement(
	                        'span',
	                        { className: 'separator' },
	                        '...'
	                    )
	                ),
	                endRange === maxRange ? '' : this.renderPageItem(maxRange)
	            ),
	            React.createElement(
	                'ul',
	                { className: 'pagination-nav' },
	                page < 1 ? '' : this.renderPageItem(page - 1, '« previous page'),
	                page >= maxRange - 1 ? '' : this.renderPageItem(page + 1, 'next page »')
	            )
	        );
	    }
	});

	module.exports = Pagination;

/***/ },

/***/ 527:
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var React = __webpack_require__(87);
	var classNames = __webpack_require__(102);

	var Icon = __webpack_require__(127);
	var Form = __webpack_require__(503);
	var Input = __webpack_require__(490);

	var SearchBar = React.createClass({
	    displayName: 'SearchBar',

	    propTypes: {
	        className: React.PropTypes.string,
	        placeholder: React.PropTypes.string,
	        value: React.PropTypes.string,
	        action: React.PropTypes.string,
	        name: React.PropTypes.string,
	        method: React.PropTypes.string,
	        onSubmit: React.PropTypes.func,
	        onChange: React.PropTypes.func
	    },

	    getDefaultProps: function getDefaultProps() {
	        return {
	            method: 'get'
	        };
	    },
	    getInitialState: function getInitialState() {
	        return {
	            value: this.props.value
	        };
	    },
	    componentWillReceiveProps: function componentWillReceiveProps(newProps) {
	        this.setState({
	            value: newProps.value
	        });
	    },
	    onChange: function onChange(e) {
	        var value = e.target.value;


	        this.setState({ value: value });

	        if (this.props.onChange) {
	            this.props.onChange(value);
	        }
	    },
	    onSubmit: function onSubmit(e) {
	        if (this.props.onSubmit) {
	            e.preventDefault();
	            this.props.onSubmit(this.state.value);
	        }
	    },
	    render: function render() {
	        var _props = this.props,
	            action = _props.action,
	            placeholder = _props.placeholder,
	            name = _props.name,
	            method = _props.method;
	        var value = this.state.value;


	        return React.createElement(
	            Form,
	            { className: classNames('search-bar', this.props.className),
	                method: method,
	                action: action },
	            React.createElement(Icon, { id: 'search' }),
	            React.createElement(Input, { name: name,
	                value: value,
	                onChange: this.onChange,
	                placeholder: placeholder })
	        );
	    }
	});

	module.exports = SearchBar;

/***/ }

})