'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
var React = require('/Users/nicolas/Prog/GitBook/editor/node_modules/react/react.js');

var Page = require('./components/Page');
var Example = require('./components/Example');
var CodeEditor = require('./components/CodeEditor');

var Panel = require('../src/Panel');
var Blankslate = require('../src/Blankslate');

var SCOPE = { React: React, Blankslate: Blankslate };

var EXAMPLE_DEFAULT = '<Blankslate icon="book">\n    <h3>No books</h3>\n    <p>Create a book to get started</p>\n</Blankslate>';

exports.default = function () {
    return React.createElement(
        Page,
        { title: 'Blankslates', active: 'blankslates' },
        React.createElement(
            Panel,
            null,
            React.createElement(Panel.Heading, { title: 'Blankslate' }),
            React.createElement(
                Panel.Body,
                null,
                React.createElement(
                    'p',
                    null,
                    'Blankslates are for when there is a lack of content within a page or section.',
                    ' ',
                    'Use them as placeholders to tell users why something isn\u2019t there. Be sure to provide an action to add content as well.'
                ),
                React.createElement(CodeEditor, { source: 'const Blankslate = require(\'gitbook-styleguide/lib/Blankslate\');' })
            )
        ),
        React.createElement(Example, { title: 'Default', source: EXAMPLE_DEFAULT, scope: SCOPE })
    );
};
    if (module.hot) {
      module.hot.accept()

      var Component = module.exports.default || module.exports
      Component.__route = "/blankslates"

      if (module.hot.status() !== 'idle') {
        var components = next.router.components
        for (var r in components) {
          if (!components.hasOwnProperty(r)) continue

          if (components[r].Component.__route === "/blankslates") {
            next.router.update(r, Component)
          }
        }
      }
    }
  