'use strict';

var React = require('/Users/nicolas/Prog/GitBook/editor/node_modules/react/react.js');
var classNames = require('classnames');

var Icon = React.createClass({
    displayName: 'Icon',

    propTypes: {
        // Icon of the icon in the collection
        id: React.PropTypes.string,
        // Type of collection
        type: React.PropTypes.string,
        // Extra className
        className: React.PropTypes.string,
        // Is the icon spinning?
        spin: React.PropTypes.bool
    },

    getDefaultProps: function getDefaultProps() {
        return {
            type: 'octicon',
            spin: false
        };
    },
    render: function render() {
        var _props = this.props,
            type = _props.type,
            id = _props.id,
            className = _props.className,
            spin = _props.spin;


        className = classNames(type + ' ' + type + '-' + id, className, {
            'icon-spin': spin
        });

        return React.createElement('i', { className: className });
    }
});

module.exports = Icon;