'use strict';

var React = require('/Users/nicolas/Prog/GitBook/editor/node_modules/react/react.js');
var classNames = require('classnames');

var SIZES = require('./SIZES');

var Modal = React.createClass({
    displayName: 'Modal',

    propTypes: {
        size: React.PropTypes.oneOf(SIZES),
        backdrop: React.PropTypes.bool,
        children: React.PropTypes.node,
        className: React.PropTypes.string
    },

    getDefaultProps: function getDefaultProps() {
        return {
            size: 'md',
            backdrop: true
        };
    },
    render: function render() {
        var className = classNames('modal', 'modal-' + this.props.size, this.props.className, {
            'without-backdrop': !this.props.backdrop
        });

        return React.createElement(
            'div',
            { className: className },
            this.props.children
        );
    }
});

var ModalBackdrop = React.createClass({
    displayName: 'ModalBackdrop',

    propTypes: {
        children: React.PropTypes.node
    },

    render: function render() {
        return React.createElement(
            'div',
            { className: 'modal-backdrop ' },
            this.props.children
        );
    }
});

var ModalBody = React.createClass({
    displayName: 'ModalBody',

    propTypes: {
        children: React.PropTypes.node
    },

    render: function render() {
        return React.createElement(
            'div',
            { className: 'modal-body' },
            this.props.children
        );
    }
});

var ModalFooter = React.createClass({
    displayName: 'ModalFooter',

    propTypes: {
        children: React.PropTypes.node
    },

    render: function render() {
        return React.createElement(
            'div',
            { className: 'modal-footer ' },
            this.props.children
        );
    }
});

var ModalHeading = React.createClass({
    displayName: 'ModalHeading',

    propTypes: {
        children: React.PropTypes.node,
        onClose: React.PropTypes.func,
        title: React.PropTypes.string
    },

    onClose: function onClose(e) {
        e.preventDefault();
        this.props.onClose();
    },
    render: function render() {
        if (this.props.title) {
            return React.createElement(
                'div',
                { className: 'modal-heading' },
                React.createElement(
                    'h4',
                    null,
                    this.props.title
                ),
                this.props.onClose ? React.createElement(
                    'a',
                    { href: '#', onClick: this.onClose, className: 'modal-close' },
                    '\xD7'
                ) : ''
            );
        }

        return React.createElement(
            'div',
            { className: 'modal-heading' },
            this.props.children
        );
    }
});

module.exports = Modal;
module.exports.Backdrop = ModalBackdrop;
module.exports.Body = ModalBody;
module.exports.Footer = ModalFooter;
module.exports.Heading = ModalHeading;