'use strict';

var React = require('/Users/nicolas/Prog/GitBook/editor/node_modules/react/react.js');
var classNames = require('classnames');

var STYLES = require('./STYLES');

var Panel = React.createClass({
    displayName: 'Panel',

    propTypes: {
        style: React.PropTypes.oneOf(STYLES),
        children: React.PropTypes.node
    },

    getDefaultProps: function getDefaultProps() {
        return {
            style: STYLES[0]
        };
    },
    render: function render() {
        var style = this.props.style;

        return React.createElement(
            'div',
            { className: classNames('panel', 'panel-' + style) },
            this.props.children
        );
    }
});

var PanelHeading = React.createClass({
    displayName: 'PanelHeading',

    propTypes: {
        title: React.PropTypes.string,
        children: React.PropTypes.node
    },

    render: function render() {
        var title = this.props.title;
        var inner = '';

        if (title) {
            inner = React.createElement(
                PanelTitle,
                null,
                title
            );
        }

        return React.createElement(
            'div',
            { className: 'panel-heading' },
            inner,
            this.props.children
        );
    }
});

var PanelTitle = React.createClass({
    displayName: 'PanelTitle',

    propTypes: {
        children: React.PropTypes.node
    },

    render: function render() {
        return React.createElement(
            'h3',
            { className: 'panel-title' },
            this.props.children
        );
    }
});

var PanelToolbar = React.createClass({
    displayName: 'PanelToolbar',

    propTypes: {
        children: React.PropTypes.node
    },

    render: function render() {
        return React.createElement(
            'div',
            { className: 'panel-toolbar' },
            this.props.children
        );
    }
});

var PanelBody = React.createClass({
    displayName: 'PanelBody',

    propTypes: {
        children: React.PropTypes.node
    },

    render: function render() {
        return React.createElement(
            'div',
            { className: 'panel-body' },
            this.props.children
        );
    }
});

var PanelFooter = React.createClass({
    displayName: 'PanelFooter',

    propTypes: {
        children: React.PropTypes.node
    },

    render: function render() {
        return React.createElement(
            'div',
            { className: 'panel-footer' },
            this.props.children
        );
    }
});

module.exports = Panel;
module.exports.Heading = PanelHeading;
module.exports.Title = PanelTitle;
module.exports.Body = PanelBody;
module.exports.Footer = PanelFooter;
module.exports.Toolbar = PanelToolbar;