'use strict';

var _extends2 = require('/Users/nicolas/Prog/GitBook/styleguide/node_modules/next/node_modules/babel-runtime/helpers/extends');

var _extends3 = _interopRequireDefault(_extends2);

var _objectWithoutProperties2 = require('/Users/nicolas/Prog/GitBook/styleguide/node_modules/next/node_modules/babel-runtime/helpers/objectWithoutProperties');

var _objectWithoutProperties3 = _interopRequireDefault(_objectWithoutProperties2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var React = require('/Users/nicolas/Prog/GitBook/editor/node_modules/react/react.js');
var classNames = require('classnames');

var Link = require('./Link');

var POSITIONS = ['bottom', 'top'];

/**
 * Pop content with controls over content:
 *
 * <Popover.Container>
 *   <Button>Open</Button>
 *   {open?
 *      <Popover>
 *         <Popover.Heading title="Hello" />
 *         <Popover.Body>...</Popover.Body>
 *         <Popover.Controls>
 *           <Popover.Control onClick={...}>Say Hello</Popover.Control>
 *           <Popover.Control onClick={...}>Say World</Popover.Control>
 *         </Popover.Controls>
 *      </Popover>
 *   : null}
 * </Popover.Container>
 */

var Popover = React.createClass({
    displayName: 'Popover',

    propTypes: {
        position: React.PropTypes.oneOf(POSITIONS),
        children: React.PropTypes.node
    },

    getDefaultProps: function getDefaultProps() {
        return {
            position: POSITIONS[0]
        };
    },
    render: function render() {
        var position = this.props.position;

        var className = classNames('popover', 'popover-' + position);

        return React.createElement(
            'div',
            { className: 'popover-wrapper' },
            React.createElement(
                'div',
                { className: className },
                React.createElement(
                    PopoverCard,
                    null,
                    React.createElement('div', { className: 'popover-arrow' }),
                    this.props.children
                )
            )
        );
    }
});

var PopoverContainer = React.createClass({
    displayName: 'PopoverContainer',

    propTypes: {
        children: React.PropTypes.node,
        className: React.PropTypes.string
    },

    render: function render() {
        var _props = this.props,
            className = _props.className,
            props = (0, _objectWithoutProperties3.default)(_props, ['className']);

        className = classNames('popover-container', className);

        return React.createElement(
            'div',
            (0, _extends3.default)({ className: className }, props),
            this.props.children
        );
    }
});

// The actual element that looks like a popup card.
var PopoverCard = React.createClass({
    displayName: 'PopoverCard',

    propTypes: {
        children: React.PropTypes.node
    },

    render: function render() {
        return React.createElement(
            'div',
            (0, _extends3.default)({ className: 'popover-card' }, this.props),
            this.props.children
        );
    }
});

var PopoverBody = React.createClass({
    displayName: 'PopoverBody',

    propTypes: {
        children: React.PropTypes.node
    },

    render: function render() {
        return React.createElement(
            'div',
            { className: 'popover-body' },
            this.props.children
        );
    }
});

var PopoverHeading = React.createClass({
    displayName: 'PopoverHeading',

    propTypes: {
        title: React.PropTypes.string,
        children: React.PropTypes.node
    },

    render: function render() {
        if (this.props.title) {
            return React.createElement(
                'div',
                { className: 'popover-heading' },
                React.createElement(
                    'span',
                    { className: 'popover-title' },
                    this.props.title
                )
            );
        }

        return React.createElement(
            'div',
            { className: 'popover-header' },
            this.props.children
        );
    }
});

var PopoverControl = React.createClass({
    displayName: 'PopoverControl',

    propTypes: {
        children: React.PropTypes.node,
        onClick: React.PropTypes.func
    },

    render: function render() {
        var onClick = this.props.onClick;


        return React.createElement(
            Link,
            { className: 'control', onClick: onClick },
            this.props.children
        );
    }
});

var PopoverControls = React.createClass({
    displayName: 'PopoverControls',

    propTypes: {
        children: React.PropTypes.node
    },

    render: function render() {
        return React.createElement(
            'div',
            { className: 'popover-controls' },
            this.props.children
        );
    }
});

module.exports = Popover;
module.exports.Card = PopoverCard;
module.exports.Body = PopoverBody;
module.exports.Heading = PopoverHeading;
module.exports.Container = PopoverContainer;
module.exports.Control = PopoverControl;
module.exports.Controls = PopoverControls;