'use strict';

var React = require('/Users/nicolas/Prog/GitBook/editor/node_modules/react/react.js');
var classNames = require('classnames');
var SIZES = require('./SIZES');

var Row = React.createClass({
    displayName: 'Row',

    propTypes: {
        children: React.PropTypes.node
    },

    render: function render() {
        return React.createElement(
            'div',
            { className: 'row' },
            this.props.children
        );
    }
});

var Container = require('./Container');

var Column = React.createClass({
    displayName: 'Column',

    propTypes: {
        children: React.PropTypes.node,
        // oneOf(SIZES): React.PropTypes.number,
        offset: React.PropTypes.number
    },

    render: function render() {
        var _this = this;

        var _props = this.props,
            offset = _props.offset,
            children = _props.children;


        var className = classNames(SIZES.reduce(function (list, size) {
            var col = _this.props[size];

            if (col) {
                list.push(['col', size, col].join('-'));
            }
            if (col && offset) {
                list.push(['col', size, 'offset', offset].join('-'));
            }

            return list;
        }, []));

        return React.createElement(
            'div',
            { className: className },
            children
        );
    }
});

module.exports = Row;
module.exports.Container = Container;
module.exports.Col = Column;