'use strict';

var React = require('/Users/nicolas/Prog/GitBook/styleguide/node_modules/react/react.js');
var Slate = require('slate');
var Prism = require('slate-prism');
require('prismjs/components/prism-jsx');

var plugins = [Prism({
    onlyIn: function onlyIn(node) {
        return true;
    },
    getSyntax: function getSyntax(node) {
        return 'jsx';
    }
})];

var CodeEditor = React.createClass({
    displayName: 'CodeEditor',

    propTypes: {
        source: React.PropTypes.string,
        onChange: React.PropTypes.func
    },

    getDefaultProps: function getDefaultProps() {
        return {
            source: ''
        };
    },


    // Setup initial state for editor
    getInitialState: function getInitialState() {
        var source = this.props.source;

        return {
            state: Slate.Plain.deserialize(source)
        };
    },


    // Editor has been modified
    onChange: function onChange(state) {
        var source = Slate.Plain.serialize(state);
        this.setState({ state: state });
        this.props.onChange(source);
    },
    render: function render() {
        var state = this.state.state;

        return React.createElement(
            'pre',
            null,
            React.createElement(Slate.Editor, {
                spellCheck: false,
                state: state,
                plugins: plugins,
                onChange: this.onChange
            })
        );
    }
});

module.exports = CodeEditor;
    if (module.hot) {
      module.hot.accept()

      var Component = module.exports.default || module.exports
      Component.__route = "/components/CodeEditor"

      if (module.hot.status() !== 'idle') {
        var components = next.router.components
        for (var r in components) {
          if (!components.hasOwnProperty(r)) continue

          if (components[r].Component.__route === "/components/CodeEditor") {
            next.router.update(r, Component)
          }
        }
      }
    }
  