'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
var React = require('/Users/nicolas/Prog/GitBook/styleguide/node_modules/react/react.js');

var Page = require('./components/Page');
var Example = require('./components/Example');
var CodeEditor = require('./components/CodeEditor');

var Panel = require('../src/Panel');
var Link = require('../src/Link');

var SCOPE = { React: React, Link: Link };

var EXAMPLE_DEFAULT = '\n<ul>\n    <li>\n        <Link href="https://www.gitbook.com" target="_blank">Normal link</Link>\n    </li>\n    <li>\n        <Link muted={true}>Muted link</Link>\n    </li>\n\n    <li>\n        <Link underlined={true}>Underlined link</Link>\n    </li>\n\n    <li>\n        <Link onClick={() => window.alert(\'onClick\')}>onClick link</Link>\n    </li>\n</ul>\n';

exports.default = function () {
    return React.createElement(
        Page,
        { title: 'Links', active: 'links' },
        React.createElement(
            Panel,
            null,
            React.createElement(Panel.Heading, { title: 'Links' }),
            React.createElement(
                Panel.Body,
                null,
                React.createElement(
                    'p',
                    null,
                    'Some links'
                ),
                React.createElement(CodeEditor, { source: 'const Link = require(\'gitbook-styleguide/lib/Link\');' })
            )
        ),
        React.createElement(Example, { title: 'Default', source: EXAMPLE_DEFAULT, scope: SCOPE })
    );
};
    if (module.hot) {
      module.hot.accept()

      var Component = module.exports.default || module.exports
      Component.__route = "/links"

      if (module.hot.status() !== 'idle') {
        var components = next.router.components
        for (var r in components) {
          if (!components.hasOwnProperty(r)) continue

          if (components[r].Component.__route === "/links") {
            next.router.update(r, Component)
          }
        }
      }
    }
  