'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
var React = require('/Users/nicolas/Prog/GitBook/styleguide/node_modules/react/react.js');

var Page = require('./components/Page');
var Example = require('./components/Example');
var CodeEditor = require('./components/CodeEditor');

var Panel = require('../src/Panel');
var Table = require('../src/Table');
var ListGroup = require('../src/ListGroup');

var SCOPE = { React: React, Panel: Panel, Table: Table, ListGroup: ListGroup };

var EXAMPLE_IMPORT = 'const Panel = require(\'gitbook-styleguide/lib/Panel\');';

var EXAMPLE_DEFAULT = '<Panel>\n    <Panel.Heading title="Title" />\n    <Panel.Body>\n        Body of the panel\n    </Panel.Body>\n</Panel>';

var EXAMPLE_STYLES = '<Panel style="danger">\n    <Panel.Heading title="Title" />\n    <Panel.Body>\n        Body of the panel\n    </Panel.Body>\n</Panel>';

var EXAMPLE_LISTGROUP = '<Panel>\n    <Panel.Heading title="Title" />\n    <ListGroup>\n        <ListGroup.Item active={true}>Account</ListGroup.Item>\n        <ListGroup.Item>Profile</ListGroup.Item>\n        <ListGroup.Item>Notifications</ListGroup.Item>\n    </ListGroup>\n</Panel>';

var EXAMPLE_TABLE = '<Panel>\n    <Panel.Heading title="Title" />\n    <Table>\n        <thead>\n            <tr>\n                <th>Title</th>\n                <th>Updated</th>\n            </tr>\n        </thead>\n        <tbody>\n            <tr>\n                <td>PHP</td>\n                <td>1 month ago</td>\n            </tr>\n            <tr>\n                <td>JS</td>\n                <td>1 month ago</td>\n            </tr>\n        </tbody>\n    </Table>\n</Panel>';

exports.default = function () {
    return React.createElement(
        Page,
        { title: 'Panels', active: 'panels' },
        React.createElement(
            Panel,
            null,
            React.createElement(Panel.Heading, { title: 'Panel' }),
            React.createElement(
                Panel.Body,
                null,
                React.createElement('p', null),
                React.createElement(CodeEditor, { source: EXAMPLE_IMPORT })
            )
        ),
        React.createElement(Example, { title: 'Example', source: EXAMPLE_DEFAULT, scope: SCOPE }),
        React.createElement(Example, { title: 'Styles', source: EXAMPLE_STYLES, scope: SCOPE }),
        React.createElement(Example, { title: 'With a table', source: EXAMPLE_TABLE, scope: SCOPE }),
        React.createElement(Example, { title: 'With a list group', source: EXAMPLE_LISTGROUP, scope: SCOPE })
    );
};
    if (module.hot) {
      module.hot.accept()

      var Component = module.exports.default || module.exports
      Component.__route = "/panels"

      if (module.hot.status() !== 'idle') {
        var components = next.router.components
        for (var r in components) {
          if (!components.hasOwnProperty(r)) continue

          if (components[r].Component.__route === "/panels") {
            next.router.update(r, Component)
          }
        }
      }
    }
  