'use strict';

var React = require('/Users/nicolas/Prog/GitBook/styleguide/node_modules/react/react.js');

/**
 * Backdrop for modals, dropdown, popover.
 *
 *
 * For example:
 *
 * <Backdrop onClose={onClosePopover}>
 *      <Popover>...</Popover>
 * </Backdrop>
 */
var Backdrop = React.createClass({
    displayName: 'Backdrop',

    propTypes: {
        // Close on escape
        escape: React.PropTypes.bool,
        // Z-index for the backdrop
        zIndex: React.PropTypes.number,
        // Callback when backdrop is closed
        onClose: React.PropTypes.func.isRequired,
        children: React.PropTypes.node.isRequired,
        wrapper: React.PropTypes.node
    },

    getDefaultProps: function getDefaultProps() {
        return {
            escape: true,
            zIndex: 200,
            wrapper: React.createElement('div', null)
        };
    },
    onClose: function onClose() {
        var onClose = this.props.onClose;

        onClose();
    },
    onKeyDown: function onKeyDown(event) {
        var escape = this.props.escape;


        if (event.keyCode === 27 && escape) {
            this.onClose();
        }
    },
    componentDidMount: function componentDidMount() {
        window.addEventListener('keydown', this.onKeyDown);
    },
    componentWillUnmount: function componentWillUnmount() {
        window.removeEventListener('keydown', this.onKeyDown);
    },
    render: function render() {
        var _props = this.props,
            zIndex = _props.zIndex,
            wrapper = _props.wrapper;

        var style = {
            zIndex: zIndex,
            position: 'fixed',
            top: 0,
            right: 0,
            width: '100%',
            height: '100%'
        };

        return React.cloneElement(wrapper, {}, React.createElement('div', { style: style, onClick: this.onClose }), wrapper.props.children, this.props.children);
    }
});

module.exports = Backdrop;