'use strict';

var React = require('/Users/nicolas/Prog/GitBook/styleguide/node_modules/react/react.js');
var classNames = require('classnames');

var FilterItem = React.createClass({
    displayName: 'FilterItem',

    propTypes: {
        children: React.PropTypes.node,
        selected: React.PropTypes.bool,
        href: React.PropTypes.string,
        className: React.PropTypes.string,
        count: React.PropTypes.number,
        onClick: React.PropTypes.func
    },

    getDefaultProps: function getDefaultProps() {
        return {
            selected: false,
            href: '#'
        };
    },
    onClick: function onClick(e) {
        if (!this.props.onClick) {
            return;
        }

        e.preventDefault();
        this.props.onClick();
    },
    render: function render() {
        var className = classNames('filter-item', this.props.className, {
            selected: this.props.selected
        });
        var count = this.props.count;
        var href = this.props.href;
        var inner = '';

        if (typeof count !== 'undefined') {
            inner = React.createElement(
                'span',
                { className: 'count' },
                count
            );
        }

        return React.createElement(
            'li',
            null,
            React.createElement(
                'a',
                { className: className, href: href, onClick: this.onClick },
                inner,
                this.props.children
            )
        );
    }
});

var FilterList = React.createClass({
    displayName: 'FilterList',

    propTypes: {
        children: React.PropTypes.node
    },

    render: function render() {
        return React.createElement(
            'ul',
            { className: 'filter-list' },
            this.props.children
        );
    }
});

module.exports = FilterList;
module.exports.Item = FilterItem;