'use strict';

var _extends2 = require('/Users/nicolas/Prog/GitBook/styleguide/node_modules/babel-runtime/helpers/extends');

var _extends3 = _interopRequireDefault(_extends2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var React = require('/Users/nicolas/Prog/GitBook/styleguide/node_modules/react/react.js');
var classNames = require('classnames');

var SIZES = require('./SIZES');

var Input = React.createClass({
    displayName: 'Input',

    propTypes: {
        className: React.PropTypes.string,
        onChange: React.PropTypes.func,
        onFocus: React.PropTypes.func,
        onBlur: React.PropTypes.func,
        onPaste: React.PropTypes.func,
        onKeyDown: React.PropTypes.func,
        onClick: React.PropTypes.func,
        name: React.PropTypes.string,
        type: React.PropTypes.string,
        placeholder: React.PropTypes.string,
        disabled: React.PropTypes.bool,
        focus: React.PropTypes.bool,
        readOnly: React.PropTypes.bool,
        autoFocus: React.PropTypes.bool,
        size: React.PropTypes.oneOf(SIZES),
        defaultValue: React.PropTypes.string,
        value: React.PropTypes.oneOfType([React.PropTypes.string, React.PropTypes.bool])
    },

    /*
        APIs for parent component
     */
    focus: function focus() {
        this.refs.input.focus();
    },
    blur: function blur() {
        this.refs.input.blur();
    },
    getDefaultProps: function getDefaultProps() {
        return {
            type: 'text',
            size: SIZES[0]
        };
    },
    onChange: function onChange(e) {
        if (this.props.onChange) {
            this.props.onChange(e);
        }
    },
    render: function render() {
        var _props = this.props,
            onPaste = _props.onPaste,
            onBlur = _props.onBlur,
            onFocus = _props.onFocus,
            onKeyDown = _props.onKeyDown,
            onClick = _props.onClick,
            value = _props.value,
            readOnly = _props.readOnly,
            defaultValue = _props.defaultValue,
            size = _props.size,
            autoFocus = _props.autoFocus,
            placeholder = _props.placeholder,
            type = _props.type,
            focus = _props.focus,
            name = _props.name,
            disabled = _props.disabled;


        var className = classNames('form-control', 'input-' + size, this.props.className, {
            focus: focus
        });

        return React.createElement('input', { ref: 'input',
            type: type, autoFocus: autoFocus,
            className: className, disabled: disabled, readOnly: readOnly,
            name: name, value: value, defaultValue: defaultValue,
            placeholder: placeholder,
            onFocus: onFocus,
            onBlur: onBlur,
            onKeyDown: onKeyDown,
            onClick: onClick,
            onPaste: onPaste,
            onChange: this.onChange
        });
    }
});

/**
 * Create a style of alert
 * @param {String} style
 * @return {React.Component}
 */
function createInputType(type) {
    return React.createClass({
        displayName: Input.displayName + type,
        render: function render() {
            return React.createElement(Input, (0, _extends3.default)({}, this.props, { type: type.toLowerCase() }));
        }
    });
}

var InputGroup = React.createClass({
    displayName: 'InputGroup',

    propTypes: {
        children: React.PropTypes.node,
        className: React.PropTypes.string
    },

    render: function render() {
        var className = classNames('input-group', this.props.className || []);
        return React.createElement(
            'div',
            { className: className },
            this.props.children
        );
    }
});

var InputGroupAddon = React.createClass({
    displayName: 'InputGroupAddon',

    propTypes: {
        children: React.PropTypes.node
    },

    render: function render() {
        return React.createElement(
            'span',
            (0, _extends3.default)({}, this.props, { className: 'input-group-addon' }),
            this.props.children
        );
    }
});

module.exports = Input;
module.exports.Email = createInputType('Email');
module.exports.Password = createInputType('Password');
module.exports.Group = InputGroup;
module.exports.GroupAddon = InputGroupAddon;