'use strict';

var React = require('/Users/nicolas/Prog/GitBook/styleguide/node_modules/react/react.js');
var classNames = require('classnames');

var ListItem = React.createClass({
    displayName: 'ListItem',

    propTypes: {
        active: React.PropTypes.bool,
        href: React.PropTypes.string,
        className: React.PropTypes.string,
        onClick: React.PropTypes.func,
        children: React.PropTypes.node
    },

    getDefaultProps: function getDefaultProps() {
        return {
            active: false,
            href: '#'
        };
    },
    onClick: function onClick(e) {
        if (!this.props.onClick) {
            return;
        }

        e.preventDefault();
        this.props.onClick();
    },
    render: function render() {
        var className = classNames('list-group-item', this.props.className, {
            active: this.props.active
        });

        return React.createElement(
            'a',
            { href: this.props.href, className: className, onClick: this.onClick },
            this.props.children
        );
    }
});

var ListGroup = React.createClass({
    displayName: 'ListGroup',

    propTypes: {
        children: React.PropTypes.node
    },

    render: function render() {
        return React.createElement(
            'ul',
            { className: 'list-group' },
            this.props.children
        );
    }
});

module.exports = ListGroup;
module.exports.Item = ListItem;