'use strict';

var React = require('/Users/nicolas/Prog/GitBook/styleguide/node_modules/react/react.js');
var classNames = require('classnames');

/**
 *   <Menu>
 *       <Menu.Item>...</Menu.Item>
 *       <Menu.Item>...</Menu.Item>
 *       <Menu.Item>...</Menu.Item>
 *   </Menu>
 */
var MenuItem = React.createClass({
    displayName: 'MenuItem',

    propTypes: {
        active: React.PropTypes.bool,
        href: React.PropTypes.string,
        className: React.PropTypes.string,
        onClick: React.PropTypes.func,
        children: React.PropTypes.node
    },

    getDefaultProps: function getDefaultProps() {
        return {
            active: false,
            href: null
        };
    },
    render: function render() {
        var _props = this.props,
            href = _props.href,
            onClick = _props.onClick;

        var className = classNames(this.props.className || '', {
            'active': this.props.active
        });

        return React.createElement(
            'li',
            { className: className },
            React.createElement(
                'a',
                { href: href || '#', onClick: onClick },
                this.props.children
            )
        );
    }
});

var Menu = React.createClass({
    displayName: 'Menu',

    propTypes: {
        right: React.PropTypes.bool,
        left: React.PropTypes.bool,
        children: React.PropTypes.node
    },

    getDefaultProps: function getDefaultProps() {
        return {
            active: false,
            href: null
        };
    },
    render: function render() {
        var className = classNames('menu', {
            'pull-right': this.props.right,
            'pull-left': this.props.left
        });

        return React.createElement(
            'ul',
            { className: className },
            this.props.children
        );
    }
});

module.exports = Menu;
module.exports.Item = MenuItem;