'use strict';

var React = require('/Users/nicolas/Prog/GitBook/styleguide/node_modules/react/react.js');
var classNames = require('classnames');

var SIZES = require('./SIZES');

var Textarea = React.createClass({
    displayName: 'Textarea',

    propTypes: {
        onChange: React.PropTypes.func,
        name: React.PropTypes.string,
        className: React.PropTypes.string,
        placeholder: React.PropTypes.string,
        disabled: React.PropTypes.bool,
        autoFocus: React.PropTypes.bool,
        size: React.PropTypes.oneOf(SIZES),
        rows: React.PropTypes.number,
        maxLength: React.PropTypes.number,
        defaultValue: React.PropTypes.string,
        value: React.PropTypes.oneOfType([React.PropTypes.string, React.PropTypes.bool])
    },

    /*
        APIs for parent component
     */
    focus: function focus() {
        this.refs.textarea.focus();
    },
    blur: function blur() {
        this.refs.textarea.blur();
    },
    getDefaultProps: function getDefaultProps() {
        return {
            size: SIZES[0],
            rows: 3
        };
    },
    onChange: function onChange(e) {
        if (this.props.onChange) {
            this.props.onChange(e);
        }
    },
    render: function render() {
        var _props = this.props,
            disabled = _props.disabled,
            name = _props.name,
            placeholder = _props.placeholder,
            size = _props.size,
            rows = _props.rows,
            autoFocus = _props.autoFocus,
            value = _props.value,
            defaultValue = _props.defaultValue,
            maxLength = _props.maxLength;


        var className = classNames('form-control', 'input-' + size, this.props.className);

        return React.createElement('textarea', { ref: 'textarea',
            className: className, rows: rows, maxLength: maxLength,
            autoFocus: autoFocus, disabled: disabled,
            name: name, value: value, defaultValue: defaultValue,
            placeholder: placeholder, onChange: this.onChange });
    }
});

module.exports = Textarea;