'use strict';

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

var React = require('react');
var classNames = require('classnames');

var Icon = require('./Icon');
var STYLES = require('./STYLES');
var SIZES = require('./SIZES');

var BUTTONS_STYLES = STYLES.concat(['link', 'marketing-primary', 'secondary', 'count']);

var Button = React.createClass({
    displayName: 'Button',

    propTypes: {
        className: React.PropTypes.string,
        children: React.PropTypes.node,
        type: React.PropTypes.string,
        size: React.PropTypes.oneOf(SIZES),
        style: React.PropTypes.oneOf(BUTTONS_STYLES),
        // Makes a link button
        href: React.PropTypes.string,
        // Form button
        value: React.PropTypes.oneOfType([React.PropTypes.string, React.PropTypes.bool, React.PropTypes.number]),
        name: React.PropTypes.string,
        // For links
        target: React.PropTypes.string,
        filled: React.PropTypes.bool,
        noBorder: React.PropTypes.bool,
        disabled: React.PropTypes.bool,
        active: React.PropTypes.bool,
        block: React.PropTypes.bool,
        dropdownToggle: React.PropTypes.bool,
        onClick: React.PropTypes.func,
        title: React.PropTypes.string,
        icon: React.PropTypes.string
    },

    getInitialState: function getInitialState() {
        return {
            clicked: false
        };
    },
    getDefaultProps: function getDefaultProps() {
        return {
            style: 'default',
            size: 'md',
            type: 'button',
            filled: false,
            disabled: false,
            active: false
        };
    },
    onClick: function onClick(e) {
        var _this = this;

        var clicked = this.state.clicked;


        if (this.props.onClick && !clicked) {
            this.props.onClick(e);
        }

        if (!this.isFormButton()) {
            return;
        } else if (clicked) {
            return this.setState({
                clicked: false
            });
        }

        // Add this submitting button's value to the form as hidden
        // input. Only after that do the click.
        // This fixes issues with PJAX[1] in Firefox[2]
        // [1]: https://github.com/defunkt/jquery-pjax/pull/295
        // [2]: http://stackoverflow.com/questions/38277900/formdata-object-does-not-add-submit-type-inputs-from-form-while-on-firefox
        e.preventDefault();
        this.setState({
            clicked: true
        }, function () {
            _this.refs.button.click();
        });
    },
    isFormButton: function isFormButton() {
        var _props = this.props,
            type = _props.type,
            name = _props.name;

        return type === 'submit' && name;
    },
    render: function render() {
        var clicked = this.state.clicked;

        var _props2 = this.props,
            title = _props2.title,
            icon = _props2.icon,
            filled = _props2.filled,
            block = _props2.block,
            noBorder = _props2.noBorder,
            active = _props2.active,
            dropdownToggle = _props2.dropdownToggle,
            style = _props2.style,
            size = _props2.size,
            className = _props2.className,
            children = _props2.children,
            name = _props2.name,
            value = _props2.value,
            disabled = _props2.disabled,
            props = _objectWithoutProperties(_props2, ['title', 'icon', 'filled', 'block', 'noBorder', 'active', 'dropdownToggle', 'style', 'size', 'className', 'children', 'name', 'value', 'disabled']);

        var inner = icon ? React.createElement(Icon, { className: icon }) : '';

        props.className = classNames('btn', 'btn-' + style, 'btn-' + size, className, {
            'btn-fill': filled,
            'btn-block': block,
            'btn-noborder': noBorder,
            active: active, disabled: disabled,
            'dropdown-toggle': dropdownToggle,
            'tooltipped': Boolean(title)
        });
        props['aria-label'] = title;
        props.role = 'button';
        props.disabled = disabled;

        var input = void 0;

        if (clicked && this.isFormButton()) {
            input = React.createElement('input', { type: 'hidden', name: name, value: value });
        }

        if (props.href) {
            delete props.type;
            return React.createElement(
                'a',
                props,
                inner,
                ' ',
                children
            );
        } else {
            return React.createElement(
                'button',
                _extends({ ref: 'button' }, props),
                inner,
                ' ',
                children,
                input
            );
        }
    }
});

var ButtonGroup = React.createClass({
    displayName: 'ButtonGroup',

    propTypes: {
        className: React.PropTypes.string,
        children: React.PropTypes.node,
        pull: React.PropTypes.string,
        block: React.PropTypes.bool
    },

    render: function render() {
        var _props3 = this.props,
            className = _props3.className,
            pull = _props3.pull,
            children = _props3.children,
            block = _props3.block;


        className = classNames('btn-group', className, pull ? 'pull-' + pull : '', {
            'btn-group-block': block
        });

        return React.createElement(
            'div',
            { className: className },
            children
        );
    }
});

var ButtonToolbar = React.createClass({
    displayName: 'ButtonToolbar',

    propTypes: {
        className: React.PropTypes.string,
        children: React.PropTypes.node
    },

    render: function render() {
        return React.createElement(
            'div',
            { className: 'btn-toolbar ' + (this.props.className || '') },
            this.props.children
        );
    }
});

var ButtonCaret = React.createClass({
    displayName: 'ButtonCaret',
    render: function render() {
        return React.createElement('span', { className: 'caret' });
    }
});

var ButtonTextExpander = React.createClass({
    displayName: 'ButtonTextExpander',

    propTypes: {
        onClick: React.PropTypes.func
    },

    onClick: function onClick(e) {
        if (this.props.onClick) {
            this.props.onClick();
        }
    },
    render: function render() {
        return React.createElement(
            'span',
            { className: 'hidden-text-expander' },
            React.createElement(
                'button',
                { type: 'button', className: 'ellipsis-expander', onClick: this.onClick },
                '\u2026'
            )
        );
    }
});

module.exports = Button;
module.exports.Group = ButtonGroup;
module.exports.Toolbar = ButtonToolbar;
module.exports.Caret = ButtonCaret;
module.exports.TextExpander = ButtonTextExpander;
module.exports.STYLES = BUTTONS_STYLES;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uL3NyYy9CdXR0b24uanMiXSwibmFtZXMiOlsiUmVhY3QiLCJyZXF1aXJlIiwiY2xhc3NOYW1lcyIsIkljb24iLCJTVFlMRVMiLCJTSVpFUyIsIkJVVFRPTlNfU1RZTEVTIiwiY29uY2F0IiwiQnV0dG9uIiwiY3JlYXRlQ2xhc3MiLCJwcm9wVHlwZXMiLCJjbGFzc05hbWUiLCJQcm9wVHlwZXMiLCJzdHJpbmciLCJjaGlsZHJlbiIsIm5vZGUiLCJ0eXBlIiwic2l6ZSIsIm9uZU9mIiwic3R5bGUiLCJocmVmIiwidmFsdWUiLCJvbmVPZlR5cGUiLCJib29sIiwibnVtYmVyIiwibmFtZSIsInRhcmdldCIsImZpbGxlZCIsIm5vQm9yZGVyIiwiZGlzYWJsZWQiLCJhY3RpdmUiLCJibG9jayIsImRyb3Bkb3duVG9nZ2xlIiwib25DbGljayIsImZ1bmMiLCJ0aXRsZSIsImljb24iLCJnZXRJbml0aWFsU3RhdGUiLCJjbGlja2VkIiwiZ2V0RGVmYXVsdFByb3BzIiwiZSIsInN0YXRlIiwicHJvcHMiLCJpc0Zvcm1CdXR0b24iLCJzZXRTdGF0ZSIsInByZXZlbnREZWZhdWx0IiwicmVmcyIsImJ1dHRvbiIsImNsaWNrIiwicmVuZGVyIiwiaW5uZXIiLCJCb29sZWFuIiwicm9sZSIsImlucHV0IiwiQnV0dG9uR3JvdXAiLCJwdWxsIiwiQnV0dG9uVG9vbGJhciIsIkJ1dHRvbkNhcmV0IiwiQnV0dG9uVGV4dEV4cGFuZGVyIiwibW9kdWxlIiwiZXhwb3J0cyIsIkdyb3VwIiwiVG9vbGJhciIsIkNhcmV0IiwiVGV4dEV4cGFuZGVyIl0sIm1hcHBpbmdzIjoiOzs7Ozs7QUFBQSxJQUFNQSxRQUFRQyxRQUFRLE9BQVIsQ0FBZDtBQUNBLElBQU1DLGFBQWFELFFBQVEsWUFBUixDQUFuQjs7QUFFQSxJQUFNRSxPQUFPRixRQUFRLFFBQVIsQ0FBYjtBQUNBLElBQU1HLFNBQVNILFFBQVEsVUFBUixDQUFmO0FBQ0EsSUFBTUksUUFBUUosUUFBUSxTQUFSLENBQWQ7O0FBRUEsSUFBTUssaUJBQWlCRixPQUFPRyxNQUFQLENBQWMsQ0FDakMsTUFEaUMsRUFFakMsbUJBRmlDLEVBR2pDLFdBSGlDLEVBSWpDLE9BSmlDLENBQWQsQ0FBdkI7O0FBT0EsSUFBTUMsU0FBU1IsTUFBTVMsV0FBTixDQUFrQjtBQUFBOztBQUM3QkMsZUFBVztBQUNQQyxtQkFBZ0JYLE1BQU1ZLFNBQU4sQ0FBZ0JDLE1BRHpCO0FBRVBDLGtCQUFnQmQsTUFBTVksU0FBTixDQUFnQkcsSUFGekI7QUFHUEMsY0FBZ0JoQixNQUFNWSxTQUFOLENBQWdCQyxNQUh6QjtBQUlQSSxjQUFnQmpCLE1BQU1ZLFNBQU4sQ0FBZ0JNLEtBQWhCLENBQXNCYixLQUF0QixDQUpUO0FBS1BjLGVBQWdCbkIsTUFBTVksU0FBTixDQUFnQk0sS0FBaEIsQ0FBc0JaLGNBQXRCLENBTFQ7QUFNUDtBQUNBYyxjQUFnQnBCLE1BQU1ZLFNBQU4sQ0FBZ0JDLE1BUHpCO0FBUVA7QUFDQVEsZUFBZ0JyQixNQUFNWSxTQUFOLENBQWdCVSxTQUFoQixDQUEwQixDQUN0Q3RCLE1BQU1ZLFNBQU4sQ0FBZ0JDLE1BRHNCLEVBRXRDYixNQUFNWSxTQUFOLENBQWdCVyxJQUZzQixFQUd0Q3ZCLE1BQU1ZLFNBQU4sQ0FBZ0JZLE1BSHNCLENBQTFCLENBVFQ7QUFjUEMsY0FBZ0J6QixNQUFNWSxTQUFOLENBQWdCQyxNQWR6QjtBQWVQO0FBQ0FhLGdCQUFnQjFCLE1BQU1ZLFNBQU4sQ0FBZ0JDLE1BaEJ6QjtBQWlCUGMsZ0JBQWdCM0IsTUFBTVksU0FBTixDQUFnQlcsSUFqQnpCO0FBa0JQSyxrQkFBZ0I1QixNQUFNWSxTQUFOLENBQWdCVyxJQWxCekI7QUFtQlBNLGtCQUFnQjdCLE1BQU1ZLFNBQU4sQ0FBZ0JXLElBbkJ6QjtBQW9CUE8sZ0JBQWdCOUIsTUFBTVksU0FBTixDQUFnQlcsSUFwQnpCO0FBcUJQUSxlQUFnQi9CLE1BQU1ZLFNBQU4sQ0FBZ0JXLElBckJ6QjtBQXNCUFMsd0JBQWdCaEMsTUFBTVksU0FBTixDQUFnQlcsSUF0QnpCO0FBdUJQVSxpQkFBZ0JqQyxNQUFNWSxTQUFOLENBQWdCc0IsSUF2QnpCO0FBd0JQQyxlQUFnQm5DLE1BQU1ZLFNBQU4sQ0FBZ0JDLE1BeEJ6QjtBQXlCUHVCLGNBQWdCcEMsTUFBTVksU0FBTixDQUFnQkM7QUF6QnpCLEtBRGtCOztBQTZCN0J3QixtQkE3QjZCLDZCQTZCWDtBQUNkLGVBQU87QUFDSEMscUJBQVM7QUFETixTQUFQO0FBR0gsS0FqQzRCO0FBbUM3QkMsbUJBbkM2Qiw2QkFtQ1g7QUFDZCxlQUFPO0FBQ0hwQixtQkFBVSxTQURQO0FBRUhGLGtCQUFVLElBRlA7QUFHSEQsa0JBQVUsUUFIUDtBQUlIVyxvQkFBVSxLQUpQO0FBS0hFLHNCQUFVLEtBTFA7QUFNSEMsb0JBQVU7QUFOUCxTQUFQO0FBUUgsS0E1QzRCO0FBOEM3QkcsV0E5QzZCLG1CQThDckJPLENBOUNxQixFQThDbEI7QUFBQTs7QUFBQSxZQUNDRixPQURELEdBQ2EsS0FBS0csS0FEbEIsQ0FDQ0gsT0FERDs7O0FBR1AsWUFBSSxLQUFLSSxLQUFMLENBQVdULE9BQVgsSUFBc0IsQ0FBQ0ssT0FBM0IsRUFBb0M7QUFDaEMsaUJBQUtJLEtBQUwsQ0FBV1QsT0FBWCxDQUFtQk8sQ0FBbkI7QUFDSDs7QUFFRCxZQUFJLENBQUMsS0FBS0csWUFBTCxFQUFMLEVBQTBCO0FBQ3RCO0FBQ0gsU0FGRCxNQUVPLElBQUlMLE9BQUosRUFBYTtBQUNoQixtQkFBTyxLQUFLTSxRQUFMLENBQWM7QUFDakJOLHlCQUFTO0FBRFEsYUFBZCxDQUFQO0FBR0g7O0FBRUQ7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBRSxVQUFFSyxjQUFGO0FBQ0EsYUFBS0QsUUFBTCxDQUFjO0FBQ1ZOLHFCQUFTO0FBREMsU0FBZCxFQUVHLFlBQU07QUFDTCxrQkFBS1EsSUFBTCxDQUFVQyxNQUFWLENBQWlCQyxLQUFqQjtBQUNILFNBSkQ7QUFLSCxLQXhFNEI7QUEwRTdCTCxnQkExRTZCLDBCQTBFZDtBQUFBLHFCQUNZLEtBQUtELEtBRGpCO0FBQUEsWUFDSDFCLElBREcsVUFDSEEsSUFERztBQUFBLFlBQ0dTLElBREgsVUFDR0EsSUFESDs7QUFFWCxlQUFPVCxTQUFTLFFBQVQsSUFBcUJTLElBQTVCO0FBQ0gsS0E3RTRCO0FBK0U3QndCLFVBL0U2QixvQkErRXBCO0FBQUEsWUFDR1gsT0FESCxHQUNlLEtBQUtHLEtBRHBCLENBQ0dILE9BREg7O0FBQUEsc0JBTUQsS0FBS0ksS0FOSjtBQUFBLFlBR0RQLEtBSEMsV0FHREEsS0FIQztBQUFBLFlBR01DLElBSE4sV0FHTUEsSUFITjtBQUFBLFlBR1lULE1BSFosV0FHWUEsTUFIWjtBQUFBLFlBR29CSSxLQUhwQixXQUdvQkEsS0FIcEI7QUFBQSxZQUcyQkgsUUFIM0IsV0FHMkJBLFFBSDNCO0FBQUEsWUFHcUNFLE1BSHJDLFdBR3FDQSxNQUhyQztBQUFBLFlBRzZDRSxjQUg3QyxXQUc2Q0EsY0FIN0M7QUFBQSxZQUlEYixLQUpDLFdBSURBLEtBSkM7QUFBQSxZQUlNRixJQUpOLFdBSU1BLElBSk47QUFBQSxZQUlZTixTQUpaLFdBSVlBLFNBSlo7QUFBQSxZQUl1QkcsUUFKdkIsV0FJdUJBLFFBSnZCO0FBQUEsWUFJaUNXLElBSmpDLFdBSWlDQSxJQUpqQztBQUFBLFlBSXVDSixLQUp2QyxXQUl1Q0EsS0FKdkM7QUFBQSxZQUk4Q1EsUUFKOUMsV0FJOENBLFFBSjlDO0FBQUEsWUFLRWEsS0FMRjs7QUFTTCxZQUFNUSxRQUFRZCxPQUFPLG9CQUFDLElBQUQsSUFBTSxXQUFXQSxJQUFqQixHQUFQLEdBQW1DLEVBQWpEOztBQUVBTSxjQUFNL0IsU0FBTixHQUFrQlQsV0FDZCxLQURjLEVBQ1AsU0FBU2lCLEtBREYsRUFDUyxTQUFTRixJQURsQixFQUVkTixTQUZjLEVBRUg7QUFDUCx3QkFBbUJnQixNQURaO0FBRVAseUJBQW1CSSxLQUZaO0FBR1AsNEJBQW1CSCxRQUhaO0FBSVBFLDBCQUpPLEVBSUNELGtCQUpEO0FBS1AsK0JBQW1CRyxjQUxaO0FBTVAsMEJBQW1CbUIsUUFBUWhCLEtBQVI7QUFOWixTQUZHLENBQWxCO0FBV0FPLGNBQU0sWUFBTixJQUFzQlAsS0FBdEI7QUFDQU8sY0FBTVUsSUFBTixHQUFzQixRQUF0QjtBQUNBVixjQUFNYixRQUFOLEdBQXNCQSxRQUF0Qjs7QUFFQSxZQUFJd0IsY0FBSjs7QUFFQSxZQUFJZixXQUFXLEtBQUtLLFlBQUwsRUFBZixFQUFvQztBQUNoQ1Usb0JBQVEsK0JBQU8sTUFBSyxRQUFaLEVBQXFCLE1BQU01QixJQUEzQixFQUFpQyxPQUFPSixLQUF4QyxHQUFSO0FBQ0g7O0FBRUQsWUFBSXFCLE1BQU10QixJQUFWLEVBQWdCO0FBQ1osbUJBQU9zQixNQUFNMUIsSUFBYjtBQUNBLG1CQUFPO0FBQUE7QUFBTzBCLHFCQUFQO0FBQWVRLHFCQUFmO0FBQUE7QUFBdUJwQztBQUF2QixhQUFQO0FBQ0gsU0FIRCxNQUdPO0FBQ0gsbUJBQU87QUFBQTtBQUFBLDJCQUFRLEtBQUksUUFBWixJQUF5QjRCLEtBQXpCO0FBQWlDUSxxQkFBakM7QUFBQTtBQUF5Q3BDLHdCQUF6QztBQUFtRHVDO0FBQW5ELGFBQVA7QUFDSDtBQUNKO0FBckg0QixDQUFsQixDQUFmOztBQXdIQSxJQUFNQyxjQUFjdEQsTUFBTVMsV0FBTixDQUFrQjtBQUFBOztBQUNsQ0MsZUFBVztBQUNQQyxtQkFBV1gsTUFBTVksU0FBTixDQUFnQkMsTUFEcEI7QUFFUEMsa0JBQVdkLE1BQU1ZLFNBQU4sQ0FBZ0JHLElBRnBCO0FBR1B3QyxjQUFXdkQsTUFBTVksU0FBTixDQUFnQkMsTUFIcEI7QUFJUGtCLGVBQVcvQixNQUFNWSxTQUFOLENBQWdCVztBQUpwQixLQUR1Qjs7QUFRbEMwQixVQVJrQyxvQkFRekI7QUFBQSxzQkFDc0MsS0FBS1AsS0FEM0M7QUFBQSxZQUNDL0IsU0FERCxXQUNDQSxTQUREO0FBQUEsWUFDWTRDLElBRFosV0FDWUEsSUFEWjtBQUFBLFlBQ2tCekMsUUFEbEIsV0FDa0JBLFFBRGxCO0FBQUEsWUFDNEJpQixLQUQ1QixXQUM0QkEsS0FENUI7OztBQUdMcEIsb0JBQVlULFdBQ1IsV0FEUSxFQUVSUyxTQUZRLEVBR1I0QyxPQUFPLFVBQVVBLElBQWpCLEdBQXdCLEVBSGhCLEVBSVI7QUFDSSwrQkFBbUJ4QjtBQUR2QixTQUpRLENBQVo7O0FBU0EsZUFBTztBQUFBO0FBQUEsY0FBSyxXQUFXcEIsU0FBaEI7QUFBNEJHO0FBQTVCLFNBQVA7QUFDSDtBQXJCaUMsQ0FBbEIsQ0FBcEI7O0FBd0JBLElBQU0wQyxnQkFBZ0J4RCxNQUFNUyxXQUFOLENBQWtCO0FBQUE7O0FBQ3BDQyxlQUFXO0FBQ1BDLG1CQUFZWCxNQUFNWSxTQUFOLENBQWdCQyxNQURyQjtBQUVQQyxrQkFBVWQsTUFBTVksU0FBTixDQUFnQkc7QUFGbkIsS0FEeUI7O0FBTXBDa0MsVUFOb0Msb0JBTTNCO0FBQ0wsZUFBTztBQUFBO0FBQUEsY0FBSyxXQUFXLGtCQUFrQixLQUFLUCxLQUFMLENBQVcvQixTQUFYLElBQXdCLEVBQTFDLENBQWhCO0FBQWdFLGlCQUFLK0IsS0FBTCxDQUFXNUI7QUFBM0UsU0FBUDtBQUNIO0FBUm1DLENBQWxCLENBQXRCOztBQVdBLElBQU0yQyxjQUFjekQsTUFBTVMsV0FBTixDQUFrQjtBQUFBO0FBQ2xDd0MsVUFEa0Msb0JBQ3pCO0FBQ0wsZUFBTyw4QkFBTSxXQUFVLE9BQWhCLEdBQVA7QUFDSDtBQUhpQyxDQUFsQixDQUFwQjs7QUFNQSxJQUFNUyxxQkFBcUIxRCxNQUFNUyxXQUFOLENBQWtCO0FBQUE7O0FBQ3pDQyxlQUFXO0FBQ1B1QixpQkFBU2pDLE1BQU1ZLFNBQU4sQ0FBZ0JzQjtBQURsQixLQUQ4Qjs7QUFLekNELFdBTHlDLG1CQUtqQ08sQ0FMaUMsRUFLOUI7QUFDUCxZQUFJLEtBQUtFLEtBQUwsQ0FBV1QsT0FBZixFQUF3QjtBQUNwQixpQkFBS1MsS0FBTCxDQUFXVCxPQUFYO0FBQ0g7QUFDSixLQVR3QztBQVd6Q2dCLFVBWHlDLG9CQVdoQztBQUNMLGVBQ0k7QUFBQTtBQUFBLGNBQU0sV0FBVSxzQkFBaEI7QUFDSTtBQUFBO0FBQUEsa0JBQVEsTUFBSyxRQUFiLEVBQXNCLFdBQVUsbUJBQWhDLEVBQW9ELFNBQVMsS0FBS2hCLE9BQWxFO0FBQUE7QUFBQTtBQURKLFNBREo7QUFLSDtBQWpCd0MsQ0FBbEIsQ0FBM0I7O0FBb0JBMEIsT0FBT0MsT0FBUCxHQUE4QnBELE1BQTlCO0FBQ0FtRCxPQUFPQyxPQUFQLENBQWVDLEtBQWYsR0FBOEJQLFdBQTlCO0FBQ0FLLE9BQU9DLE9BQVAsQ0FBZUUsT0FBZixHQUE4Qk4sYUFBOUI7QUFDQUcsT0FBT0MsT0FBUCxDQUFlRyxLQUFmLEdBQThCTixXQUE5QjtBQUNBRSxPQUFPQyxPQUFQLENBQWVJLFlBQWYsR0FBOEJOLGtCQUE5QjtBQUNBQyxPQUFPQyxPQUFQLENBQWV4RCxNQUFmLEdBQThCRSxjQUE5QiIsImZpbGUiOiJCdXR0b24uanMiLCJzb3VyY2VzQ29udGVudCI6WyJjb25zdCBSZWFjdCA9IHJlcXVpcmUoJ3JlYWN0Jyk7XG5jb25zdCBjbGFzc05hbWVzID0gcmVxdWlyZSgnY2xhc3NuYW1lcycpO1xuXG5jb25zdCBJY29uID0gcmVxdWlyZSgnLi9JY29uJyk7XG5jb25zdCBTVFlMRVMgPSByZXF1aXJlKCcuL1NUWUxFUycpO1xuY29uc3QgU0laRVMgPSByZXF1aXJlKCcuL1NJWkVTJyk7XG5cbmNvbnN0IEJVVFRPTlNfU1RZTEVTID0gU1RZTEVTLmNvbmNhdChbXG4gICAgJ2xpbmsnLFxuICAgICdtYXJrZXRpbmctcHJpbWFyeScsXG4gICAgJ3NlY29uZGFyeScsXG4gICAgJ2NvdW50J1xuXSk7XG5cbmNvbnN0IEJ1dHRvbiA9IFJlYWN0LmNyZWF0ZUNsYXNzKHtcbiAgICBwcm9wVHlwZXM6IHtcbiAgICAgICAgY2xhc3NOYW1lOiAgICAgIFJlYWN0LlByb3BUeXBlcy5zdHJpbmcsXG4gICAgICAgIGNoaWxkcmVuOiAgICAgICBSZWFjdC5Qcm9wVHlwZXMubm9kZSxcbiAgICAgICAgdHlwZTogICAgICAgICAgIFJlYWN0LlByb3BUeXBlcy5zdHJpbmcsXG4gICAgICAgIHNpemU6ICAgICAgICAgICBSZWFjdC5Qcm9wVHlwZXMub25lT2YoU0laRVMpLFxuICAgICAgICBzdHlsZTogICAgICAgICAgUmVhY3QuUHJvcFR5cGVzLm9uZU9mKEJVVFRPTlNfU1RZTEVTKSxcbiAgICAgICAgLy8gTWFrZXMgYSBsaW5rIGJ1dHRvblxuICAgICAgICBocmVmOiAgICAgICAgICAgUmVhY3QuUHJvcFR5cGVzLnN0cmluZyxcbiAgICAgICAgLy8gRm9ybSBidXR0b25cbiAgICAgICAgdmFsdWU6ICAgICAgICAgIFJlYWN0LlByb3BUeXBlcy5vbmVPZlR5cGUoW1xuICAgICAgICAgICAgUmVhY3QuUHJvcFR5cGVzLnN0cmluZyxcbiAgICAgICAgICAgIFJlYWN0LlByb3BUeXBlcy5ib29sLFxuICAgICAgICAgICAgUmVhY3QuUHJvcFR5cGVzLm51bWJlclxuICAgICAgICBdKSxcbiAgICAgICAgbmFtZTogICAgICAgICAgIFJlYWN0LlByb3BUeXBlcy5zdHJpbmcsXG4gICAgICAgIC8vIEZvciBsaW5rc1xuICAgICAgICB0YXJnZXQ6ICAgICAgICAgUmVhY3QuUHJvcFR5cGVzLnN0cmluZyxcbiAgICAgICAgZmlsbGVkOiAgICAgICAgIFJlYWN0LlByb3BUeXBlcy5ib29sLFxuICAgICAgICBub0JvcmRlcjogICAgICAgUmVhY3QuUHJvcFR5cGVzLmJvb2wsXG4gICAgICAgIGRpc2FibGVkOiAgICAgICBSZWFjdC5Qcm9wVHlwZXMuYm9vbCxcbiAgICAgICAgYWN0aXZlOiAgICAgICAgIFJlYWN0LlByb3BUeXBlcy5ib29sLFxuICAgICAgICBibG9jazogICAgICAgICAgUmVhY3QuUHJvcFR5cGVzLmJvb2wsXG4gICAgICAgIGRyb3Bkb3duVG9nZ2xlOiBSZWFjdC5Qcm9wVHlwZXMuYm9vbCxcbiAgICAgICAgb25DbGljazogICAgICAgIFJlYWN0LlByb3BUeXBlcy5mdW5jLFxuICAgICAgICB0aXRsZTogICAgICAgICAgUmVhY3QuUHJvcFR5cGVzLnN0cmluZyxcbiAgICAgICAgaWNvbjogICAgICAgICAgIFJlYWN0LlByb3BUeXBlcy5zdHJpbmdcbiAgICB9LFxuXG4gICAgZ2V0SW5pdGlhbFN0YXRlKCkge1xuICAgICAgICByZXR1cm4ge1xuICAgICAgICAgICAgY2xpY2tlZDogZmFsc2VcbiAgICAgICAgfTtcbiAgICB9LFxuXG4gICAgZ2V0RGVmYXVsdFByb3BzKCkge1xuICAgICAgICByZXR1cm4ge1xuICAgICAgICAgICAgc3R5bGU6ICAgICdkZWZhdWx0JyxcbiAgICAgICAgICAgIHNpemU6ICAgICAnbWQnLFxuICAgICAgICAgICAgdHlwZTogICAgICdidXR0b24nLFxuICAgICAgICAgICAgZmlsbGVkOiAgIGZhbHNlLFxuICAgICAgICAgICAgZGlzYWJsZWQ6IGZhbHNlLFxuICAgICAgICAgICAgYWN0aXZlOiAgIGZhbHNlXG4gICAgICAgIH07XG4gICAgfSxcblxuICAgIG9uQ2xpY2soZSkge1xuICAgICAgICBjb25zdCB7IGNsaWNrZWQgfSA9IHRoaXMuc3RhdGU7XG5cbiAgICAgICAgaWYgKHRoaXMucHJvcHMub25DbGljayAmJiAhY2xpY2tlZCkge1xuICAgICAgICAgICAgdGhpcy5wcm9wcy5vbkNsaWNrKGUpO1xuICAgICAgICB9XG5cbiAgICAgICAgaWYgKCF0aGlzLmlzRm9ybUJ1dHRvbigpKSB7XG4gICAgICAgICAgICByZXR1cm47XG4gICAgICAgIH0gZWxzZSBpZiAoY2xpY2tlZCkge1xuICAgICAgICAgICAgcmV0dXJuIHRoaXMuc2V0U3RhdGUoe1xuICAgICAgICAgICAgICAgIGNsaWNrZWQ6IGZhbHNlXG4gICAgICAgICAgICB9KTtcbiAgICAgICAgfVxuXG4gICAgICAgIC8vIEFkZCB0aGlzIHN1Ym1pdHRpbmcgYnV0dG9uJ3MgdmFsdWUgdG8gdGhlIGZvcm0gYXMgaGlkZGVuXG4gICAgICAgIC8vIGlucHV0LiBPbmx5IGFmdGVyIHRoYXQgZG8gdGhlIGNsaWNrLlxuICAgICAgICAvLyBUaGlzIGZpeGVzIGlzc3VlcyB3aXRoIFBKQVhbMV0gaW4gRmlyZWZveFsyXVxuICAgICAgICAvLyBbMV06IGh0dHBzOi8vZ2l0aHViLmNvbS9kZWZ1bmt0L2pxdWVyeS1wamF4L3B1bGwvMjk1XG4gICAgICAgIC8vIFsyXTogaHR0cDovL3N0YWNrb3ZlcmZsb3cuY29tL3F1ZXN0aW9ucy8zODI3NzkwMC9mb3JtZGF0YS1vYmplY3QtZG9lcy1ub3QtYWRkLXN1Ym1pdC10eXBlLWlucHV0cy1mcm9tLWZvcm0td2hpbGUtb24tZmlyZWZveFxuICAgICAgICBlLnByZXZlbnREZWZhdWx0KCk7XG4gICAgICAgIHRoaXMuc2V0U3RhdGUoe1xuICAgICAgICAgICAgY2xpY2tlZDogdHJ1ZVxuICAgICAgICB9LCAoKSA9PiB7XG4gICAgICAgICAgICB0aGlzLnJlZnMuYnV0dG9uLmNsaWNrKCk7XG4gICAgICAgIH0pO1xuICAgIH0sXG5cbiAgICBpc0Zvcm1CdXR0b24oKSB7XG4gICAgICAgIGNvbnN0IHsgdHlwZSwgbmFtZSB9ID0gdGhpcy5wcm9wcztcbiAgICAgICAgcmV0dXJuIHR5cGUgPT09ICdzdWJtaXQnICYmIG5hbWU7XG4gICAgfSxcblxuICAgIHJlbmRlcigpIHtcbiAgICAgICAgY29uc3QgeyBjbGlja2VkIH0gPSB0aGlzLnN0YXRlO1xuICAgICAgICBjb25zdCB7XG4gICAgICAgICAgICB0aXRsZSwgaWNvbiwgZmlsbGVkLCBibG9jaywgbm9Cb3JkZXIsIGFjdGl2ZSwgZHJvcGRvd25Ub2dnbGUsXG4gICAgICAgICAgICBzdHlsZSwgc2l6ZSwgY2xhc3NOYW1lLCBjaGlsZHJlbiwgbmFtZSwgdmFsdWUsIGRpc2FibGVkLFxuICAgICAgICAgICAgLi4ucHJvcHNcbiAgICAgICAgfSA9IHRoaXMucHJvcHM7XG5cblxuICAgICAgICBjb25zdCBpbm5lciA9IGljb24gPyA8SWNvbiBjbGFzc05hbWU9e2ljb259IC8+IDogJyc7XG5cbiAgICAgICAgcHJvcHMuY2xhc3NOYW1lID0gY2xhc3NOYW1lcyhcbiAgICAgICAgICAgICdidG4nLCAnYnRuLScgKyBzdHlsZSwgJ2J0bi0nICsgc2l6ZSxcbiAgICAgICAgICAgIGNsYXNzTmFtZSwge1xuICAgICAgICAgICAgICAgICdidG4tZmlsbCc6ICAgICAgICBmaWxsZWQsXG4gICAgICAgICAgICAgICAgJ2J0bi1ibG9jayc6ICAgICAgIGJsb2NrLFxuICAgICAgICAgICAgICAgICdidG4tbm9ib3JkZXInOiAgICBub0JvcmRlcixcbiAgICAgICAgICAgICAgICBhY3RpdmUsIGRpc2FibGVkLFxuICAgICAgICAgICAgICAgICdkcm9wZG93bi10b2dnbGUnOiBkcm9wZG93blRvZ2dsZSxcbiAgICAgICAgICAgICAgICAndG9vbHRpcHBlZCc6ICAgICAgQm9vbGVhbih0aXRsZSlcbiAgICAgICAgICAgIH1cbiAgICAgICAgKTtcbiAgICAgICAgcHJvcHNbJ2FyaWEtbGFiZWwnXSA9IHRpdGxlO1xuICAgICAgICBwcm9wcy5yb2xlICAgICAgICAgID0gJ2J1dHRvbic7XG4gICAgICAgIHByb3BzLmRpc2FibGVkICAgICAgPSBkaXNhYmxlZDtcblxuICAgICAgICBsZXQgaW5wdXQ7XG5cbiAgICAgICAgaWYgKGNsaWNrZWQgJiYgdGhpcy5pc0Zvcm1CdXR0b24oKSkge1xuICAgICAgICAgICAgaW5wdXQgPSA8aW5wdXQgdHlwZT1cImhpZGRlblwiIG5hbWU9e25hbWV9IHZhbHVlPXt2YWx1ZX0gLz47XG4gICAgICAgIH1cblxuICAgICAgICBpZiAocHJvcHMuaHJlZikge1xuICAgICAgICAgICAgZGVsZXRlIHByb3BzLnR5cGU7XG4gICAgICAgICAgICByZXR1cm4gPGEgey4uLnByb3BzfT57aW5uZXJ9IHtjaGlsZHJlbn08L2E+O1xuICAgICAgICB9IGVsc2Uge1xuICAgICAgICAgICAgcmV0dXJuIDxidXR0b24gcmVmPVwiYnV0dG9uXCIgey4uLnByb3BzfT57aW5uZXJ9IHtjaGlsZHJlbn17aW5wdXR9PC9idXR0b24+O1xuICAgICAgICB9XG4gICAgfVxufSk7XG5cbmNvbnN0IEJ1dHRvbkdyb3VwID0gUmVhY3QuY3JlYXRlQ2xhc3Moe1xuICAgIHByb3BUeXBlczoge1xuICAgICAgICBjbGFzc05hbWU6IFJlYWN0LlByb3BUeXBlcy5zdHJpbmcsXG4gICAgICAgIGNoaWxkcmVuOiAgUmVhY3QuUHJvcFR5cGVzLm5vZGUsXG4gICAgICAgIHB1bGw6ICAgICAgUmVhY3QuUHJvcFR5cGVzLnN0cmluZyxcbiAgICAgICAgYmxvY2s6ICAgICBSZWFjdC5Qcm9wVHlwZXMuYm9vbFxuICAgIH0sXG5cbiAgICByZW5kZXIoKSB7XG4gICAgICAgIGxldCB7IGNsYXNzTmFtZSwgcHVsbCwgY2hpbGRyZW4sIGJsb2NrIH0gPSB0aGlzLnByb3BzO1xuXG4gICAgICAgIGNsYXNzTmFtZSA9IGNsYXNzTmFtZXMoXG4gICAgICAgICAgICAnYnRuLWdyb3VwJyxcbiAgICAgICAgICAgIGNsYXNzTmFtZSxcbiAgICAgICAgICAgIHB1bGwgPyAncHVsbC0nICsgcHVsbCA6ICcnLFxuICAgICAgICAgICAge1xuICAgICAgICAgICAgICAgICdidG4tZ3JvdXAtYmxvY2snOiBibG9ja1xuICAgICAgICAgICAgfVxuICAgICAgICApO1xuXG4gICAgICAgIHJldHVybiA8ZGl2IGNsYXNzTmFtZT17Y2xhc3NOYW1lfT57Y2hpbGRyZW59PC9kaXY+O1xuICAgIH1cbn0pO1xuXG5jb25zdCBCdXR0b25Ub29sYmFyID0gUmVhY3QuY3JlYXRlQ2xhc3Moe1xuICAgIHByb3BUeXBlczoge1xuICAgICAgICBjbGFzc05hbWU6ICBSZWFjdC5Qcm9wVHlwZXMuc3RyaW5nLFxuICAgICAgICBjaGlsZHJlbjogUmVhY3QuUHJvcFR5cGVzLm5vZGVcbiAgICB9LFxuXG4gICAgcmVuZGVyKCkge1xuICAgICAgICByZXR1cm4gPGRpdiBjbGFzc05hbWU9eydidG4tdG9vbGJhciAnICsgKHRoaXMucHJvcHMuY2xhc3NOYW1lIHx8ICcnKX0+e3RoaXMucHJvcHMuY2hpbGRyZW59PC9kaXY+O1xuICAgIH1cbn0pO1xuXG5jb25zdCBCdXR0b25DYXJldCA9IFJlYWN0LmNyZWF0ZUNsYXNzKHtcbiAgICByZW5kZXIoKSB7XG4gICAgICAgIHJldHVybiA8c3BhbiBjbGFzc05hbWU9XCJjYXJldFwiIC8+O1xuICAgIH1cbn0pO1xuXG5jb25zdCBCdXR0b25UZXh0RXhwYW5kZXIgPSBSZWFjdC5jcmVhdGVDbGFzcyh7XG4gICAgcHJvcFR5cGVzOiB7XG4gICAgICAgIG9uQ2xpY2s6IFJlYWN0LlByb3BUeXBlcy5mdW5jXG4gICAgfSxcblxuICAgIG9uQ2xpY2soZSkge1xuICAgICAgICBpZiAodGhpcy5wcm9wcy5vbkNsaWNrKSB7XG4gICAgICAgICAgICB0aGlzLnByb3BzLm9uQ2xpY2soKTtcbiAgICAgICAgfVxuICAgIH0sXG5cbiAgICByZW5kZXIoKSB7XG4gICAgICAgIHJldHVybiAoXG4gICAgICAgICAgICA8c3BhbiBjbGFzc05hbWU9XCJoaWRkZW4tdGV4dC1leHBhbmRlclwiPlxuICAgICAgICAgICAgICAgIDxidXR0b24gdHlwZT1cImJ1dHRvblwiIGNsYXNzTmFtZT1cImVsbGlwc2lzLWV4cGFuZGVyXCIgb25DbGljaz17dGhpcy5vbkNsaWNrfT4maGVsbGlwOzwvYnV0dG9uPlxuICAgICAgICAgICAgPC9zcGFuPlxuICAgICAgICApO1xuICAgIH1cbn0pO1xuXG5tb2R1bGUuZXhwb3J0cyAgICAgICAgICAgICAgPSBCdXR0b247XG5tb2R1bGUuZXhwb3J0cy5Hcm91cCAgICAgICAgPSBCdXR0b25Hcm91cDtcbm1vZHVsZS5leHBvcnRzLlRvb2xiYXIgICAgICA9IEJ1dHRvblRvb2xiYXI7XG5tb2R1bGUuZXhwb3J0cy5DYXJldCAgICAgICAgPSBCdXR0b25DYXJldDtcbm1vZHVsZS5leHBvcnRzLlRleHRFeHBhbmRlciA9IEJ1dHRvblRleHRFeHBhbmRlcjtcbm1vZHVsZS5leHBvcnRzLlNUWUxFUyAgICAgICA9IEJVVFRPTlNfU1RZTEVTO1xuIl19