'use strict';

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var React = require('react');
var classNames = require('classnames');

var SIZES = require('./SIZES');

var Input = React.createClass({
    displayName: 'Input',

    propTypes: {
        className: React.PropTypes.string,
        onChange: React.PropTypes.func,
        onFocus: React.PropTypes.func,
        onBlur: React.PropTypes.func,
        onPaste: React.PropTypes.func,
        onKeyDown: React.PropTypes.func,
        onClick: React.PropTypes.func,
        name: React.PropTypes.string,
        type: React.PropTypes.string,
        placeholder: React.PropTypes.string,
        disabled: React.PropTypes.bool,
        focus: React.PropTypes.bool,
        readOnly: React.PropTypes.bool,
        autoFocus: React.PropTypes.bool,
        size: React.PropTypes.oneOf(SIZES),
        defaultValue: React.PropTypes.string,
        value: React.PropTypes.oneOfType([React.PropTypes.string, React.PropTypes.bool])
    },

    /*
        APIs for parent component
     */
    focus: function focus() {
        this.refs.input.focus();
    },
    blur: function blur() {
        this.refs.input.blur();
    },
    getDefaultProps: function getDefaultProps() {
        return {
            type: 'text',
            size: SIZES[0]
        };
    },
    onChange: function onChange(e) {
        if (this.props.onChange) {
            this.props.onChange(e);
        }
    },
    render: function render() {
        var _props = this.props,
            onPaste = _props.onPaste,
            onBlur = _props.onBlur,
            onFocus = _props.onFocus,
            onKeyDown = _props.onKeyDown,
            onClick = _props.onClick,
            value = _props.value,
            readOnly = _props.readOnly,
            defaultValue = _props.defaultValue,
            size = _props.size,
            autoFocus = _props.autoFocus,
            placeholder = _props.placeholder,
            type = _props.type,
            focus = _props.focus,
            name = _props.name,
            disabled = _props.disabled;


        var className = classNames('form-control', 'input-' + size, this.props.className, {
            focus: focus
        });

        return React.createElement('input', { ref: 'input',
            type: type, autoFocus: autoFocus,
            className: className, disabled: disabled, readOnly: readOnly,
            name: name, value: value, defaultValue: defaultValue,
            placeholder: placeholder,
            onFocus: onFocus,
            onBlur: onBlur,
            onKeyDown: onKeyDown,
            onClick: onClick,
            onPaste: onPaste,
            onChange: this.onChange
        });
    }
});

/**
 * Create a style of alert
 * @param {String} style
 * @return {React.Component}
 */
function createInputType(type) {
    return React.createClass({
        displayName: Input.displayName + type,
        render: function render() {
            return React.createElement(Input, _extends({}, this.props, { type: type.toLowerCase() }));
        }
    });
}

var InputGroup = React.createClass({
    displayName: 'InputGroup',

    propTypes: {
        children: React.PropTypes.node,
        className: React.PropTypes.string
    },

    render: function render() {
        var className = classNames('input-group', this.props.className || []);
        return React.createElement(
            'div',
            { className: className },
            this.props.children
        );
    }
});

var InputGroupAddon = React.createClass({
    displayName: 'InputGroupAddon',

    propTypes: {
        children: React.PropTypes.node
    },

    render: function render() {
        return React.createElement(
            'span',
            _extends({}, this.props, { className: 'input-group-addon' }),
            this.props.children
        );
    }
});

module.exports = Input;
module.exports.Email = createInputType('Email');
module.exports.Password = createInputType('Password');
module.exports.Group = InputGroup;
module.exports.GroupAddon = InputGroupAddon;
//# sourceMappingURL=data:application/json;base64,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