'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
var React = require('/Users/samypesse/Projects/GitBook/styleguide/node_modules/react/react.js');

var Page = require('./components/Page');
var Example = require('./components/Example');
var CodeEditor = require('./components/CodeEditor');

var Panel = require('../src/Panel');
var Button = require('../src/Button');
var Icon = require('../src/Icon');

var SCOPE = { React: React, Button: Button, Icon: Icon };

var EXAMPLE_DEFAULT = '<Button.Toolbar>\n    <Button>Button button</Button>\n    <Button href="#">Link button</Button>\n</Button.Toolbar>';

var EXAMPLE_SIZES = '<Button.Toolbar>\n    <Button size="lg">Large button</Button>\n    <Button size="md">Normal button</Button>\n    <Button size="sm">Small button</Button>\n    <Button size="xs">Extra small button</Button>\n</Button.Toolbar>';

var EXAMPLE_STYLES = '<Button.Toolbar>\n    <Button style="primary">Primary</Button>\n    <Button style="success">Success</Button>\n    <Button style="danger">Danger</Button>\n    <Button style="secondary">Secondary</Button>\n    <Button style="link">Link</Button>\n    <Button style="marketing-primary">Marketing</Button>\n</Button.Toolbar>';

var EXAMPLE_STYLE_COUNT = '<Button.Group>\n    <Button onClick={event => this.setState({ count: this.state.count + 1 })}>\n        <Icon id="star" /> Star\n    </Button>\n    <Button href="#" style="count">{this.state.count}</Button>\n</Button.Group>';

var EXAMPLE_STATES = '<Button.Toolbar>\n    <Button>Default</Button>\n    <Button active>Active</Button>\n    <Button disabled>Disabled</Button>\n\n    <Button style="primary">Default</Button>\n    <Button style="primary" active>Active</Button>\n    <Button style="primary" disabled>Disabled</Button>\n</Button.Toolbar>';

var EXAMPLE_LABELS = '<Button.Toolbar>\n    <Button title="Label">Default</Button>\n    <Button title="Label" active>Active</Button>\n    <Button title="Label" disabled>Disabled</Button>\n</Button.Toolbar>';

var EXAMPLE_BLOCK = '<Button block style="primary">Primary block button</Button>\n<Button block>Secondary button</Button>';

var EXAMPLE_GROUP = '<Button.Toolbar>\n    <Button.Group>\n        <Button>Button</Button>\n        <Button>Button</Button>\n    </Button.Group>\n    <Button.Group>\n        <Button size="sm">Button</Button>\n        <Button size="sm">Button</Button>\n    </Button.Group>\n</Button.Toolbar>';

var EXAMPLE_GROUP_JUSTIFIED = '<Button.Group block>\n    <Button>Button</Button>\n    <Button>Button</Button>\n</Button.Group>';

exports.default = function () {
    return React.createElement(
        Page,
        { title: 'Buttons', active: 'buttons' },
        React.createElement(
            Panel,
            null,
            React.createElement(Panel.Heading, { title: 'Buttons' }),
            React.createElement(
                Panel.Body,
                null,
                React.createElement(
                    'p',
                    null,
                    'Buttons are used for actions, like in forms, while textual hyperlinks are used for destinations, or moving from one page to another.'
                ),
                React.createElement(CodeEditor, { source: 'const Button = require(\'gitbook-styleguide/lib/Button\');' })
            )
        ),
        React.createElement(Example, { title: 'Default buttons', source: EXAMPLE_DEFAULT, scope: SCOPE }),
        React.createElement(
            Example,
            { title: 'Sizes', source: EXAMPLE_SIZES, scope: SCOPE },
            'Buttons are availables in multiples sizes: Large, Normal, Small and Extra-Small.'
        ),
        React.createElement(
            Example,
            { title: 'Styles', source: EXAMPLE_STYLES, scope: SCOPE },
            'Buttons can be filled to indicate a more important action:'
        ),
        React.createElement(
            Example,
            { title: 'Counts', source: EXAMPLE_STYLE_COUNT, scope: SCOPE, state: { count: 0 } },
            'Buttons with a count.'
        ),
        React.createElement(
            Example,
            { title: 'States', source: EXAMPLE_STATES, scope: SCOPE },
            'Buttons can have different states:'
        ),
        React.createElement(
            Example,
            { title: 'Labels', source: EXAMPLE_LABELS, scope: SCOPE },
            'Buttons can have a label on hover:'
        ),
        React.createElement(
            Example,
            { title: 'Block buttons', source: EXAMPLE_BLOCK, scope: SCOPE },
            'Create block level buttons\u2014those that span the full width of a parent:'
        ),
        React.createElement(
            Example,
            { title: 'Button groups', source: EXAMPLE_GROUP, scope: SCOPE },
            'Have a hankering for a series of buttons that are attached to one another? Wrap them in a `Button.Group` and the buttons will be rounded and spaced automatically.'
        ),
        React.createElement(
            Example,
            { title: 'Justified Button groups', source: EXAMPLE_GROUP_JUSTIFIED, scope: SCOPE },
            'Button groups can be justified, to make a group of buttons stretch at equal sizes to span the entire width of its parent. Also works with button dropdowns within the button group.'
        )
    );
};
    if (module.hot) {
      module.hot.accept()

      var Component = module.exports.default || module.exports
      Component.__route = "/buttons"

      if (module.hot.status() !== 'idle') {
        var components = next.router.components
        for (var r in components) {
          if (!components.hasOwnProperty(r)) continue

          if (components[r].Component.__route === "/buttons") {
            next.router.update(r, Component)
          }
        }
      }
    }
  