'use strict';

var _keys = require('/Users/samypesse/Projects/GitBook/styleguide/node_modules/next/node_modules/babel-runtime/core-js/object/keys');

var _keys2 = _interopRequireDefault(_keys);

var _stringify = require('/Users/samypesse/Projects/GitBook/styleguide/node_modules/next/node_modules/babel-runtime/core-js/json/stringify');

var _stringify2 = _interopRequireDefault(_stringify);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var React = require('/Users/samypesse/Projects/GitBook/styleguide/node_modules/react/react.js');

var _require = require('babel-standalone'),
    transform = _require.transform;

var Alert = require('../../src/Alert');
var Panel = require('../../src/Panel');
var CodeEditor = require('./CodeEditor');

var STYLE_PRE_ERROR = {
    padding: 0,
    background: 'none',
    color: 'inherit',
    border: 'none',
    margin: 0
};

function evalCode(code, scope) {
    var initialState = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};

    // Wrap in a function
    code = '(React.createClass({\n    getInitialState() {\n        return ' + (0, _stringify2.default)(initialState) + ';\n    },\n\n    render() {\n        const {' + (0, _keys2.default)(scope).join(',') + '} = this.props;\n        return <div>' + code + '</div>\n    }\n}))';

    // Compile with babel
    code = transform(code, { presets: ['es2015', 'react', 'stage-1'] }).code;

    var Component = eval(code);
    return React.createElement(Component, scope);
}

var Example = React.createClass({
    displayName: 'Example',

    propTypes: {
        title: React.PropTypes.string,
        source: React.PropTypes.string,
        children: React.PropTypes.node,
        scope: React.PropTypes.object,
        state: React.PropTypes.object
    },

    getDefaultProps: function getDefaultProps() {
        return {
            scope: {}
        };
    },


    // Setup initial state for editor
    getInitialState: function getInitialState() {
        var source = this.props.source;

        return { source: source };
    },


    // Editor has been modified
    onChange: function onChange(source) {
        this.setState({ source: source });
    },
    render: function render() {
        var _props = this.props,
            title = _props.title,
            children = _props.children,
            scope = _props.scope,
            state = _props.state;
        var source = this.state.source;


        var result = void 0;
        try {
            result = evalCode(source, scope, state);
        } catch (error) {
            result = React.createElement(
                Alert.Danger,
                null,
                React.createElement(
                    'pre',
                    { style: STYLE_PRE_ERROR },
                    error.message
                )
            );
        }

        return React.createElement(
            Panel,
            null,
            React.createElement(Panel.Heading, { title: title }),
            children ? React.createElement(
                Panel.Body,
                null,
                children
            ) : null,
            React.createElement(
                Panel.Body,
                null,
                result
            ),
            React.createElement(
                Panel.Body,
                null,
                React.createElement(CodeEditor, { source: source, onChange: this.onChange })
            )
        );
    }
});

module.exports = Example;
    if (module.hot) {
      module.hot.accept()

      var Component = module.exports.default || module.exports
      Component.__route = "/components/Example"

      if (module.hot.status() !== 'idle') {
        var components = next.router.components
        for (var r in components) {
          if (!components.hasOwnProperty(r)) continue

          if (components[r].Component.__route === "/components/Example") {
            next.router.update(r, Component)
          }
        }
      }
    }
  