'use strict';

var _head = require('/Users/samypesse/Projects/GitBook/styleguide/node_modules/next/dist/lib/head.js');

var _head2 = _interopRequireDefault(_head);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var React = require('/Users/samypesse/Projects/GitBook/styleguide/node_modules/react/react.js');

var _require = require('react-sticky'),
    StickyContainer = _require.StickyContainer,
    Sticky = _require.Sticky;

var PageWrapper = require('../../src/PageWrapper');
var PageInner = require('../../src/PageInner');
var PageBody = require('../../src/PageBody');
var Container = require('../../src/Container');
var Panel = require('../../src/Panel');
var Row = require('../../src/Row');
var ListGroup = require('../../src/ListGroup');

var Footer = require('./Footer');
var Header = require('./Header');

var Menu = function Menu(_ref) {
    var active = _ref.active;
    return React.createElement(
        ListGroup,
        null,
        React.createElement(
            ListGroup.Item,
            { active: active == 'introduction', href: '/' },
            'Introduction'
        ),
        React.createElement(
            ListGroup.Item,
            { active: active == 'icons', href: '/icons' },
            'Logos and Icons'
        ),
        React.createElement(
            ListGroup.Item,
            { active: active == 'buttons', href: '/buttons' },
            'Buttons'
        ),
        React.createElement(
            ListGroup.Item,
            { active: active == 'links', href: '/links' },
            'Links'
        ),
        React.createElement(
            ListGroup.Item,
            { active: active == 'forms', href: '/forms' },
            'Forms and Inputs'
        ),
        React.createElement(
            ListGroup.Item,
            { active: active == 'navigation', href: '/navigation' },
            'Navigation'
        ),
        React.createElement(
            ListGroup.Item,
            { active: active == 'alerts', href: '/alerts' },
            'Alerts'
        ),
        React.createElement(
            ListGroup.Item,
            { active: active == 'blankslates', href: '/blankslates' },
            'Blankslates'
        ),
        React.createElement(
            ListGroup.Item,
            { active: active == 'modals', href: '/modals' },
            'Modals'
        ),
        React.createElement(
            ListGroup.Item,
            { active: active == 'tooltips', href: '/tooltips' },
            'Tooltips'
        ),
        React.createElement(
            ListGroup.Item,
            { active: active == 'panels', href: '/panels' },
            'Panels'
        ),
        React.createElement(
            ListGroup.Item,
            { active: active == 'dropdowns', href: '/dropdowns' },
            'Dropdowns'
        ),
        React.createElement(
            ListGroup.Item,
            { active: active == 'popovers', href: '/popovers' },
            'Popovers'
        ),
        React.createElement(
            ListGroup.Item,
            { active: active == 'autocomplete', href: '/autocomplete' },
            'Autocomplete'
        ),
        React.createElement(
            ListGroup.Item,
            { active: active == 'cards', href: '/cards' },
            'Cards'
        )
    );
};
Menu.propTypes = {
    active: React.PropTypes.bool
};

var Page = React.createClass({
    displayName: 'Page',

    propTypes: {
        title: React.PropTypes.string,
        active: React.PropTypes.string,
        children: React.PropTypes.node
    },

    render: function render() {
        var _props = this.props,
            title = _props.title,
            children = _props.children,
            active = _props.active;


        return React.createElement(
            PageWrapper,
            null,
            React.createElement(
                _head2.default,
                null,
                React.createElement(
                    'title',
                    null,
                    title
                ),
                React.createElement('link', { rel: 'stylesheet', href: '/static/css/gitbook.css' }),
                React.createElement('link', { rel: 'stylesheet', href: '/static/images/logo/favicon.ico' }),
                React.createElement('link', { rel: 'stylesheet', href: 'https://cdnjs.cloudflare.com/ajax/libs/prism/1.5.1/themes/prism.css' }),
                React.createElement('meta', { charSet: 'UTF-8' }),
                React.createElement('meta', { name: 'viewport', content: 'initial-scale=1.0, width=device-width' })
            ),
            React.createElement(Header, null),
            React.createElement(
                PageBody,
                null,
                React.createElement(
                    PageInner,
                    null,
                    React.createElement(
                        StickyContainer,
                        null,
                        React.createElement(
                            Container,
                            null,
                            React.createElement(
                                Row,
                                null,
                                React.createElement(
                                    Row.Col,
                                    { md: 3 },
                                    React.createElement(
                                        Sticky,
                                        { stickyStyle: { marginTop: 20 } },
                                        React.createElement(
                                            Panel,
                                            null,
                                            React.createElement(Menu, { active: active })
                                        )
                                    )
                                ),
                                React.createElement(
                                    Row.Col,
                                    { md: 9 },
                                    children
                                )
                            )
                        )
                    )
                )
            ),
            React.createElement(Footer, null)
        );
    }
});

module.exports = Page;
    if (module.hot) {
      module.hot.accept()

      var Component = module.exports.default || module.exports
      Component.__route = "/components/Page"

      if (module.hot.status() !== 'idle') {
        var components = next.router.components
        for (var r in components) {
          if (!components.hasOwnProperty(r)) continue

          if (components[r].Component.__route === "/components/Page") {
            next.router.update(r, Component)
          }
        }
      }
    }
  