'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
var React = require('/Users/samypesse/Projects/GitBook/styleguide/node_modules/react/react.js');

var Page = require('./components/Page');
var Example = require('./components/Example');
var CodeEditor = require('./components/CodeEditor');

var Panel = require('../src/Panel');
var Dropdown = require('../src/Dropdown');
var Button = require('../src/Button');
var Icon = require('../src/Icon');

var SCOPE = { React: React, Dropdown: Dropdown, Button: Button, Icon: Icon };

var EXAMPLE_IMPORT = 'const Dropdown = require(\'gitbook-styleguide/lib/Dropdown\')';
var EXAMPLE_DEFAULT = '<Dropdown>\n    <Button>Toggle dropdown</Button>\n    <Dropdown.Item header>Account</Dropdown.Item>\n    <Dropdown.Item href="/profile">Profile</Dropdown.Item>\n    <Dropdown.Item href="/settings">Settings</Dropdown.Item>\n    <Dropdown.Divider />\n    <Dropdown.Item onClick={e => alert(\'Logout\')}>Logout</Dropdown.Item>\n</Dropdown>';

exports.default = function () {
    return React.createElement(
        Page,
        { title: 'Dropdowns', active: 'dropdowns' },
        React.createElement(
            Panel,
            null,
            React.createElement(Panel.Heading, { title: 'Dropdowns' }),
            React.createElement(
                Panel.Body,
                null,
                React.createElement(CodeEditor, { source: EXAMPLE_IMPORT })
            )
        ),
        React.createElement(Example, { title: 'Default', source: EXAMPLE_DEFAULT, scope: SCOPE })
    );
};
    if (module.hot) {
      module.hot.accept()

      var Component = module.exports.default || module.exports
      Component.__route = "/dropdowns"

      if (module.hot.status() !== 'idle') {
        var components = next.router.components
        for (var r in components) {
          if (!components.hasOwnProperty(r)) continue

          if (components[r].Component.__route === "/dropdowns") {
            next.router.update(r, Component)
          }
        }
      }
    }
  