'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
var React = require('react');

var Page = require('./components/Page');
var Example = require('./components/Example');
var CodeEditor = require('./components/CodeEditor');

var Panel = require('../src/Panel');
var Autocomplete = require('../src/Autocomplete');

var SCOPE = { React: React, Autocomplete: Autocomplete };

var EXAMPLE_IMPORT = 'const Autocomplete = require(\'gitbook-styleguide/lib/Autocomplete\');';

var EXAMPLE_DEFAULT = '<Autocomplete\n    placeholder="Enter a language"\n    onFetch={(query, callback) => {\n        callback([\n            { id: \'en\', label: \'English\' },\n            { id: \'fr\', label: \'French\' }\n        ])\n    }}\n    onChange={(query, result) => alert(\'Selected is \' + result.label)}\n    renderResult={({result}) => <span><b>{result.id}</b> {result.label}</span>}\n/>';

exports.default = function () {
    return React.createElement(
        Page,
        { title: 'Autocomplete', active: 'autocomplete' },
        React.createElement(
            Panel,
            null,
            React.createElement(Panel.Heading, { title: 'Autocomplete' }),
            React.createElement(
                Panel.Body,
                null,
                React.createElement(
                    'p',
                    null,
                    'Modals are streamlined, but flexible, dialog prompts with the minimum required functionality and smart defaults.'
                ),
                React.createElement(CodeEditor, { source: EXAMPLE_IMPORT })
            )
        ),
        React.createElement(Example, { title: 'Example', source: EXAMPLE_DEFAULT, scope: SCOPE })
    );
};
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInBhZ2VzL2F1dG9jb21wbGV0ZS5qcz9lbnRyeSJdLCJuYW1lcyI6WyJSZWFjdCIsInJlcXVpcmUiLCJQYWdlIiwiRXhhbXBsZSIsIkNvZGVFZGl0b3IiLCJQYW5lbCIsIkF1dG9jb21wbGV0ZSIsIlNDT1BFIiwiRVhBTVBMRV9JTVBPUlQiLCJFWEFNUExFX0RFRkFVTFQiXSwibWFwcGluZ3MiOiI7Ozs7O0FBQUEsSUFBTUEsUUFBUUMsUUFBUSxPQUFSLENBQWQ7O0FBRUEsSUFBTUMsT0FBT0QsUUFBUSxtQkFBUixDQUFiO0FBQ0EsSUFBTUUsVUFBVUYsUUFBUSxzQkFBUixDQUFoQjtBQUNBLElBQU1HLGFBQWFILFFBQVEseUJBQVIsQ0FBbkI7O0FBRUEsSUFBTUksUUFBUUosUUFBUSxjQUFSLENBQWQ7QUFDQSxJQUFNSyxlQUFlTCxRQUFRLHFCQUFSLENBQXJCOztBQUVBLElBQU1NLFFBQVEsRUFBRVAsWUFBRixFQUFTTSwwQkFBVCxFQUFkOztBQUVBLElBQU1FLGlCQUNOLHdFQURBOztBQUdBLElBQU1DLGlaQUFOOztrQkFhZSxZQUFNO0FBQ2pCLFdBQ0k7QUFBQyxZQUFEO0FBQUEsVUFBTSxPQUFNLGNBQVosRUFBMkIsUUFBTyxjQUFsQztBQUNJO0FBQUMsaUJBQUQ7QUFBQTtBQUNJLGdDQUFDLEtBQUQsQ0FBTyxPQUFQLElBQWUsT0FBTSxjQUFyQixHQURKO0FBRUk7QUFBQyxxQkFBRCxDQUFPLElBQVA7QUFBQTtBQUNJO0FBQUE7QUFBQTtBQUFBO0FBQUEsaUJBREo7QUFFSSxvQ0FBQyxVQUFELElBQVksUUFBUUQsY0FBcEI7QUFGSjtBQUZKLFNBREo7QUFTSSw0QkFBQyxPQUFELElBQVMsT0FBTSxTQUFmLEVBQXlCLFFBQVFDLGVBQWpDLEVBQWtELE9BQU9GLEtBQXpEO0FBVEosS0FESjtBQWFILEMiLCJmaWxlIjoiYXV0b2NvbXBsZXRlLmpzP2VudHJ5Iiwic291cmNlUm9vdCI6Ii9Vc2Vycy9zYW15cGVzc2UvUHJvamVjdHMvR2l0Qm9vay9zdHlsZWd1aWRlIiwic291cmNlc0NvbnRlbnQiOlsiY29uc3QgUmVhY3QgPSByZXF1aXJlKCdyZWFjdCcpO1xuXG5jb25zdCBQYWdlID0gcmVxdWlyZSgnLi9jb21wb25lbnRzL1BhZ2UnKTtcbmNvbnN0IEV4YW1wbGUgPSByZXF1aXJlKCcuL2NvbXBvbmVudHMvRXhhbXBsZScpO1xuY29uc3QgQ29kZUVkaXRvciA9IHJlcXVpcmUoJy4vY29tcG9uZW50cy9Db2RlRWRpdG9yJyk7XG5cbmNvbnN0IFBhbmVsID0gcmVxdWlyZSgnLi4vc3JjL1BhbmVsJyk7XG5jb25zdCBBdXRvY29tcGxldGUgPSByZXF1aXJlKCcuLi9zcmMvQXV0b2NvbXBsZXRlJyk7XG5cbmNvbnN0IFNDT1BFID0geyBSZWFjdCwgQXV0b2NvbXBsZXRlIH07XG5cbmNvbnN0IEVYQU1QTEVfSU1QT1JUID1cbidjb25zdCBBdXRvY29tcGxldGUgPSByZXF1aXJlKFxcJ2dpdGJvb2stc3R5bGVndWlkZS9saWIvQXV0b2NvbXBsZXRlXFwnKTsnO1xuXG5jb25zdCBFWEFNUExFX0RFRkFVTFQgPVxuYDxBdXRvY29tcGxldGVcbiAgICBwbGFjZWhvbGRlcj1cIkVudGVyIGEgbGFuZ3VhZ2VcIlxuICAgIG9uRmV0Y2g9eyhxdWVyeSwgY2FsbGJhY2spID0+IHtcbiAgICAgICAgY2FsbGJhY2soW1xuICAgICAgICAgICAgeyBpZDogJ2VuJywgbGFiZWw6ICdFbmdsaXNoJyB9LFxuICAgICAgICAgICAgeyBpZDogJ2ZyJywgbGFiZWw6ICdGcmVuY2gnIH1cbiAgICAgICAgXSlcbiAgICB9fVxuICAgIG9uQ2hhbmdlPXsocXVlcnksIHJlc3VsdCkgPT4gYWxlcnQoJ1NlbGVjdGVkIGlzICcgKyByZXN1bHQubGFiZWwpfVxuICAgIHJlbmRlclJlc3VsdD17KHtyZXN1bHR9KSA9PiA8c3Bhbj48Yj57cmVzdWx0LmlkfTwvYj4ge3Jlc3VsdC5sYWJlbH08L3NwYW4+fVxuLz5gO1xuXG5leHBvcnQgZGVmYXVsdCAoKSA9PiB7XG4gICAgcmV0dXJuIChcbiAgICAgICAgPFBhZ2UgdGl0bGU9XCJBdXRvY29tcGxldGVcIiBhY3RpdmU9XCJhdXRvY29tcGxldGVcIj5cbiAgICAgICAgICAgIDxQYW5lbD5cbiAgICAgICAgICAgICAgICA8UGFuZWwuSGVhZGluZyB0aXRsZT1cIkF1dG9jb21wbGV0ZVwiIC8+XG4gICAgICAgICAgICAgICAgPFBhbmVsLkJvZHk+XG4gICAgICAgICAgICAgICAgICAgIDxwPk1vZGFscyBhcmUgc3RyZWFtbGluZWQsIGJ1dCBmbGV4aWJsZSwgZGlhbG9nIHByb21wdHMgd2l0aCB0aGUgbWluaW11bSByZXF1aXJlZCBmdW5jdGlvbmFsaXR5IGFuZCBzbWFydCBkZWZhdWx0cy48L3A+XG4gICAgICAgICAgICAgICAgICAgIDxDb2RlRWRpdG9yIHNvdXJjZT17RVhBTVBMRV9JTVBPUlR9IC8+XG4gICAgICAgICAgICAgICAgPC9QYW5lbC5Cb2R5PlxuICAgICAgICAgICAgPC9QYW5lbD5cblxuICAgICAgICAgICAgPEV4YW1wbGUgdGl0bGU9XCJFeGFtcGxlXCIgc291cmNlPXtFWEFNUExFX0RFRkFVTFR9IHNjb3BlPXtTQ09QRX0+PC9FeGFtcGxlPlxuICAgICAgICA8L1BhZ2U+XG4gICAgKTtcbn07XG4iXX0=