'use strict';

var React = require('react');
var Slate = require('slate');
var Prism = require('slate-prism');
require('prismjs/components/prism-jsx');

var plugins = [Prism({
    onlyIn: function onlyIn(node) {
        return true;
    },
    getSyntax: function getSyntax(node) {
        return 'jsx';
    }
})];

var CodeEditor = React.createClass({
    displayName: 'CodeEditor',

    propTypes: {
        source: React.PropTypes.string,
        onChange: React.PropTypes.func
    },

    getDefaultProps: function getDefaultProps() {
        return {
            source: ''
        };
    },


    // Setup initial state for editor
    getInitialState: function getInitialState() {
        var source = this.props.source;

        return {
            state: Slate.Plain.deserialize(source)
        };
    },


    // Editor has been modified
    onChange: function onChange(state) {
        var source = Slate.Plain.serialize(state);
        this.setState({ state: state });
        this.props.onChange(source);
    },
    render: function render() {
        var state = this.state.state;

        return React.createElement(
            'pre',
            null,
            React.createElement(Slate.Editor, {
                spellCheck: false,
                state: state,
                plugins: plugins,
                onChange: this.onChange
            })
        );
    }
});

module.exports = CodeEditor;
//# sourceMappingURL=data:application/json;base64,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