'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
var React = require('react');

var Page = require('./components/Page');
var Example = require('./components/Example');
var CodeEditor = require('./components/CodeEditor');

var Panel = require('../src/Panel');
var Button = require('../src/Button');
var Icon = require('../src/Icon');

var SCOPE = { React: React, Button: Button, Icon: Icon };

var EXAMPLE_DEFAULT = '<Button.Toolbar>\n    <Button>Button button</Button>\n    <Button href="#">Link button</Button>\n</Button.Toolbar>';

var EXAMPLE_SIZES = '<Button.Toolbar>\n    <Button size="lg">Large button</Button>\n    <Button size="md">Normal button</Button>\n    <Button size="sm">Small button</Button>\n    <Button size="xs">Extra small button</Button>\n</Button.Toolbar>';

var EXAMPLE_STYLES = '<Button.Toolbar>\n    <Button style="primary">Primary</Button>\n    <Button style="success">Success</Button>\n    <Button style="danger">Danger</Button>\n    <Button style="secondary">Secondary</Button>\n    <Button style="link">Link</Button>\n    <Button style="marketing-primary">Marketing</Button>\n</Button.Toolbar>';

var EXAMPLE_STYLE_COUNT = '<Button.Group>\n    <Button onClick={event => this.setState({ count: this.state.count + 1 })}>\n        <Icon id="star" /> Star\n    </Button>\n    <Button href="#" style="count">{this.state.count}</Button>\n</Button.Group>';

var EXAMPLE_STATES = '<Button.Toolbar>\n    <Button>Default</Button>\n    <Button active>Active</Button>\n    <Button disabled>Disabled</Button>\n\n    <Button style="primary">Default</Button>\n    <Button style="primary" active>Active</Button>\n    <Button style="primary" disabled>Disabled</Button>\n</Button.Toolbar>';

var EXAMPLE_LABELS = '<Button.Toolbar>\n    <Button title="Label">Default</Button>\n    <Button title="Label" active>Active</Button>\n    <Button title="Label" disabled>Disabled</Button>\n</Button.Toolbar>';

var EXAMPLE_BLOCK = '<Button block style="primary">Primary block button</Button>\n<Button block>Secondary button</Button>';

var EXAMPLE_GROUP = '<Button.Toolbar>\n    <Button.Group>\n        <Button>Button</Button>\n        <Button>Button</Button>\n    </Button.Group>\n    <Button.Group>\n        <Button size="sm">Button</Button>\n        <Button size="sm">Button</Button>\n    </Button.Group>\n</Button.Toolbar>';

var EXAMPLE_GROUP_JUSTIFIED = '<Button.Group block>\n    <Button>Button</Button>\n    <Button>Button</Button>\n</Button.Group>';

exports.default = function () {
    return React.createElement(
        Page,
        { title: 'Buttons', active: 'buttons' },
        React.createElement(
            Panel,
            null,
            React.createElement(Panel.Heading, { title: 'Buttons' }),
            React.createElement(
                Panel.Body,
                null,
                React.createElement(
                    'p',
                    null,
                    'Buttons are used for actions, like in forms, while textual hyperlinks are used for destinations, or moving from one page to another.'
                ),
                React.createElement(CodeEditor, { source: 'const Button = require(\'gitbook-styleguide/lib/Button\');' })
            )
        ),
        React.createElement(Example, { title: 'Default buttons', source: EXAMPLE_DEFAULT, scope: SCOPE }),
        React.createElement(
            Example,
            { title: 'Sizes', source: EXAMPLE_SIZES, scope: SCOPE },
            'Buttons are availables in multiples sizes: Large, Normal, Small and Extra-Small.'
        ),
        React.createElement(
            Example,
            { title: 'Styles', source: EXAMPLE_STYLES, scope: SCOPE },
            'Buttons can be filled to indicate a more important action:'
        ),
        React.createElement(
            Example,
            { title: 'Counts', source: EXAMPLE_STYLE_COUNT, scope: SCOPE, state: { count: 0 } },
            'Buttons with a count.'
        ),
        React.createElement(
            Example,
            { title: 'States', source: EXAMPLE_STATES, scope: SCOPE },
            'Buttons can have different states:'
        ),
        React.createElement(
            Example,
            { title: 'Labels', source: EXAMPLE_LABELS, scope: SCOPE },
            'Buttons can have a label on hover:'
        ),
        React.createElement(
            Example,
            { title: 'Block buttons', source: EXAMPLE_BLOCK, scope: SCOPE },
            'Create block level buttons\u2014those that span the full width of a parent:'
        ),
        React.createElement(
            Example,
            { title: 'Button groups', source: EXAMPLE_GROUP, scope: SCOPE },
            'Have a hankering for a series of buttons that are attached to one another? Wrap them in a `Button.Group` and the buttons will be rounded and spaced automatically.'
        ),
        React.createElement(
            Example,
            { title: 'Justified Button groups', source: EXAMPLE_GROUP_JUSTIFIED, scope: SCOPE },
            'Button groups can be justified, to make a group of buttons stretch at equal sizes to span the entire width of its parent. Also works with button dropdowns within the button group.'
        )
    );
};
//# sourceMappingURL=data:application/json;base64,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