'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
var React = require('react');

var Page = require('./components/Page');
var Example = require('./components/Example');
var CodeEditor = require('./components/CodeEditor');

var Panel = require('../src/Panel');
var Card = require('../src/Card');
var Row = require('../src/Row');
var Button = require('../src/Button');
var Icon = require('../src/Icon');

var SCOPE = { React: React, Card: Card, Row: Row, Button: Button, Icon: Icon };

var EXAMPLE_IMPORT = 'const Card = require(\'gitbook-styleguide/lib/Card\')';
var EXAMPLE_DEFAULT = '<Row>\n    <Row.Col md={6}>\n        <Card>\n            <Card.Heading title="Official Documentation" />\n            <Card.Body>\n                <p>\n                    <Card.Flag><Icon id="zap" /></Card.Flag>\n                    {\' \'}Learn about our awesome API.\n                </p>\n                <p>Created 2 months ago</p>\n            </Card.Body>\n            <Card.Actions>\n                <Button>Read</Button>\n                <Button>Edit</Button>\n            </Card.Actions>\n        </Card>\n    </Row.Col>\n</Row>';

exports.default = function () {
    return React.createElement(
        Page,
        { title: 'Cards', active: 'cards' },
        React.createElement(
            Panel,
            null,
            React.createElement(Panel.Heading, { title: 'Cards' }),
            React.createElement(
                Panel.Body,
                null,
                React.createElement(
                    'p',
                    null,
                    'Cards are container for informations in a list (like books, users, plugins). Each cards has a title, body and a set of actions.'
                ),
                React.createElement(
                    'p',
                    null,
                    'Cards are design for quick access with optional secondary actions.'
                ),
                React.createElement(CodeEditor, { source: EXAMPLE_IMPORT })
            )
        ),
        React.createElement(Example, { title: 'Default', source: EXAMPLE_DEFAULT, scope: SCOPE })
    );
};
//# sourceMappingURL=data:application/json;base64,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