'use strict';

var React = require('react');

var _require = require('babel-standalone'),
    transform = _require.transform;

var Alert = require('../../src/Alert');
var Panel = require('../../src/Panel');
var CodeEditor = require('./CodeEditor');

var STYLE_PRE_ERROR = {
    padding: 0,
    background: 'none',
    color: 'inherit',
    border: 'none',
    margin: 0
};

function evalCode(code, scope) {
    var initialState = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};

    // Wrap in a function
    code = '(React.createClass({\n    getInitialState() {\n        return ' + JSON.stringify(initialState) + ';\n    },\n\n    render() {\n        const {' + Object.keys(scope).join(',') + '} = this.props;\n        return <div>' + code + '</div>\n    }\n}))';

    // Compile with babel
    code = transform(code, { presets: ['es2015', 'react', 'stage-1'] }).code;

    var Component = eval(code);
    return React.createElement(Component, scope);
}

var Example = React.createClass({
    displayName: 'Example',

    propTypes: {
        title: React.PropTypes.string,
        source: React.PropTypes.string,
        children: React.PropTypes.node,
        scope: React.PropTypes.object,
        state: React.PropTypes.object
    },

    getDefaultProps: function getDefaultProps() {
        return {
            scope: {}
        };
    },


    // Setup initial state for editor
    getInitialState: function getInitialState() {
        var source = this.props.source;

        return { source: source };
    },


    // Editor has been modified
    onChange: function onChange(source) {
        this.setState({ source: source });
    },
    render: function render() {
        var _props = this.props,
            title = _props.title,
            children = _props.children,
            scope = _props.scope,
            state = _props.state;
        var source = this.state.source;


        var result = void 0;
        try {
            result = evalCode(source, scope, state);
        } catch (error) {
            result = React.createElement(
                Alert.Danger,
                null,
                React.createElement(
                    'pre',
                    { style: STYLE_PRE_ERROR },
                    error.message
                )
            );
        }

        return React.createElement(
            Panel,
            null,
            React.createElement(Panel.Heading, { title: title }),
            children ? React.createElement(
                Panel.Body,
                null,
                children
            ) : null,
            React.createElement(
                Panel.Body,
                null,
                result
            ),
            React.createElement(
                Panel.Body,
                null,
                React.createElement(CodeEditor, { source: source, onChange: this.onChange })
            )
        );
    }
});

module.exports = Example;
//# sourceMappingURL=data:application/json;base64,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