'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
var React = require('react');

var Page = require('./components/Page');
var Panel = require('../src/Panel');
var Container = require('../src/Container');
var Row = require('../src/Row');
var Icon = require('../src/Icon');
var LogoText = require('../icons/LogoText');
var Logo = require('../icons/Logo');

var CodeEditor = require('./components/CodeEditor');

var SOURCE_IMPORT = 'const LogoText = require(\'gitbook-styleguide/icons/LogoText\');\nconst Logo = require(\'gitbook-styleguide/icons/Logo\');\nconst Icon = require(\'gitbook-styleguide/icons/Icon\');';

var LOGOS = [{ source: '<LogoText />', component: function component() {
        return React.createElement(LogoText, { size: 'md' });
    } }, { source: '<Logo />', component: function component() {
        return React.createElement(Logo, { size: 'md' });
    } }];

var OCTICONS = Icon.OCTICONS.map(function (id) {
    return {
        source: '<Icon id="' + id + '" />',
        component: function component() {
            return React.createElement(
                'span',
                { style: { fontSize: 32 } },
                React.createElement(Icon, { id: id, size: 'md' })
            );
        }
    };
});

var IconsSet = React.createClass({
    displayName: 'IconsSet',

    propTypes: {
        icons: React.PropTypes.array.isRequired,
        perLine: React.PropTypes.number
    },

    getDefaultProps: function getDefaultProps() {
        return {
            perLine: 4
        };
    },
    render: function render() {
        var _props = this.props,
            icons = _props.icons,
            perLine = _props.perLine;

        var lines = [];

        while (icons.length > 0) {
            var cells = icons.splice(0, perLine);
            lines.push(React.createElement(
                Row,
                null,
                cells.map(function (cell) {
                    return React.createElement(
                        Row.Col,
                        { md: 12 / perLine },
                        React.createElement(
                            Panel,
                            null,
                            React.createElement(
                                Panel.Body,
                                null,
                                React.createElement(
                                    'div',
                                    { style: { textAlign: 'center' } },
                                    React.createElement(cell.component, null)
                                )
                            ),
                            React.createElement(
                                Panel.Body,
                                null,
                                React.createElement(
                                    'div',
                                    { style: { textAlign: 'center' } },
                                    React.createElement(
                                        'code',
                                        null,
                                        cell.source
                                    )
                                )
                            )
                        )
                    );
                })
            ));
        }

        return React.createElement(
            Container,
            { fluid: true },
            lines
        );
    }
});

exports.default = function () {
    return React.createElement(
        Page,
        { title: 'Logos and Icons', active: 'icons' },
        React.createElement(
            Panel,
            null,
            React.createElement(Panel.Heading, { title: 'Logos and Icons' }),
            React.createElement(
                Panel.Body,
                null,
                React.createElement(
                    'p',
                    null,
                    'The styleguide provides all logos and icons as react component (rendered as an SVG).'
                ),
                React.createElement(
                    'p',
                    null,
                    'GitBook Styleguide is currently providing the octicons icons set.'
                ),
                React.createElement(CodeEditor, { source: SOURCE_IMPORT })
            )
        ),
        React.createElement(IconsSet, { icons: LOGOS }),
        React.createElement(IconsSet, { icons: OCTICONS })
    );
};
//# sourceMappingURL=data:application/json;base64,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