'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
var React = require('react');

var Page = require('./components/Page');
var Example = require('./components/Example');
var CodeEditor = require('./components/CodeEditor');

var Panel = require('../src/Panel');
var Modal = require('../src/Modal');
var Button = require('../src/Button');
var Backdrop = require('../src/Backdrop');

var SCOPE = { React: React, Modal: Modal, Button: Button, Backdrop: Backdrop };

var EXAMPLE_IMPORT = 'const Modal = require(\'gitbook-styleguide/lib/Modal\');';

var EXAMPLE_DEFAULT = '<Modal>\n    <Modal.Heading title="Title" />\n    <Modal.Body>\n        Body of the modal\n    </Modal.Body>\n    <Modal.Footer>\n        <Button style="secondary">Cancel</Button>\n        <Button style="primary">Important action</Button>\n    </Modal.Footer>\n</Modal>';

var EXAMPLE_BACKDROP = '\n<Button onClick={event => this.setState({ open: true })}>Open modal</Button>\n{this.state.open ?\n    <Backdrop wrapper={<Modal.Backdrop />} onClose={event => this.setState({ open: false })}>\n        <Modal>\n            <Modal.Heading title="Title" />\n            <Modal.Body>\n                Body of the modal\n            </Modal.Body>\n            <Modal.Footer>\n                <Button style="secondary" onClick={event => this.setState({ open: false })}>Cancel</Button>\n                <Button style="primary">Important action</Button>\n            </Modal.Footer>\n        </Modal>\n    </Backdrop>\n: null}';

exports.default = function () {
    return React.createElement(
        Page,
        { title: 'Modals', active: 'modals' },
        React.createElement(
            Panel,
            null,
            React.createElement(Panel.Heading, { title: 'Modals' }),
            React.createElement(
                Panel.Body,
                null,
                React.createElement(
                    'p',
                    null,
                    'Modals are streamlined, but flexible, dialog prompts with the minimum required functionality and smart defaults.'
                ),
                React.createElement(CodeEditor, { source: EXAMPLE_IMPORT })
            )
        ),
        React.createElement(Example, { title: 'Example', source: EXAMPLE_DEFAULT, scope: SCOPE }),
        React.createElement(Example, { title: 'With a backdrop', source: EXAMPLE_BACKDROP, scope: SCOPE })
    );
};
//# sourceMappingURL=data:application/json;base64,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