'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
var React = require('react');

var Page = require('./components/Page');
var Example = require('./components/Example');
var CodeEditor = require('./components/CodeEditor');

var Panel = require('../src/Panel');
var FilterList = require('../src/FilterList');
var Icon = require('../src/Icon');
var ListGroup = require('../src/ListGroup');
var Overview = require('../src/Overview');
var Pagination = require('../src/Pagination');
var PageHead = require('../src/PageHead');
var Menu = require('../src/Menu');
var SearchBar = require('../src/SearchBar');
var Row = require('../src/Row');
var Container = require('../src/Container');

var SCOPE = { React: React, FilterList: FilterList, Panel: Panel, ListGroup: ListGroup, Icon: Icon, Overview: Overview,
    Pagination: Pagination, PageHead: PageHead, Menu: Menu, SearchBar: SearchBar, Row: Row, Container: Container };

var EXAMPLE_IMPORTS = 'const FilterList = require(\'gitbook-styleguide/lib/FilterList\');\nconst Menu = require(\'gitbook-styleguide/lib/Menu\');\nconst SearchBar = require(\'gitbook-styleguide/lib/SearchBar\');\nconst PageHead = require(\'gitbook-styleguide/lib/PageHead\');\nconst Pagination = require(\'gitbook-styleguide/lib/Pagination\');\nconst ListGroup = require(\'gitbook-styleguide/lib/ListGroup\');\nconst Overview = require(\'gitbook-styleguide/lib/Overview\');';

var EXAMPLE_MENU = '<Panel>\n    <ListGroup>\n        <ListGroup.Item active={true}>\n            <Icon id="gear" size="sm" /> Account\n        </ListGroup.Item>\n        <ListGroup.Item>\n            <Icon id="person" size="sm" /> Profile\n        </ListGroup.Item>\n        <ListGroup.Item>\n            <Icon id="mail" size="sm" /> Notifications\n        </ListGroup.Item>\n    </ListGroup>\n</Panel>';

var EXAMPLE_PAGEHEAD_MENU = '<PageHead>\n    <Container>\n        <Row>\n            <Row.Col md={5}>\n                <PageHead.Title>\n                    Contact GitBook\n                </PageHead.Title>\n            </Row.Col>\n            <Row.Col md={7}>\n                <Menu right>\n                    <Menu.Item>About</Menu.Item>\n                    <Menu.Item active>Contact</Menu.Item>\n                    <Menu.Item>Terms of Service</Menu.Item>\n                </Menu>\n            </Row.Col>\n        </Row>\n    </Container>\n</PageHead>';

var EXAMPLE_PAGEHEAD_OVERVIEW = '<PageHead>\n    <Container>\n        <Overview>\n            <Overview.Title>\n                <Overview.StepTitle href="/">\n                    myorg\n                </Overview.StepTitle>\n                <Overview.StepDivider />\n                <Overview.StepTitle primary>\n                    My Book\n                </Overview.StepTitle>\n            </Overview.Title>\n            <Overview.Note>\n                Updated 2 days ago\n            </Overview.Note>\n        </Overview>\n    </Container>\n    <Container>\n        <Menu left>\n            <Menu.Item>Overview</Menu.Item>\n            <Menu.Item active>Metrics</Menu.Item>\n            <Menu.Item>Settings</Menu.Item>\n        </Menu>\n    </Container>\n</PageHead>';

var EXAMPLE_PAGEHEAD_SEARCH = '<PageHead>\n    <Container>\n        <Row>\n            <Row.Col md={8}>\n                <PageHead.Title>\n                    <Icon id="star" size="sm" /> Explore GitBook\n                </PageHead.Title>\n            </Row.Col>\n            <Row.Col md={4}>\n                <SearchBar placeholder="Search books" />\n            </Row.Col>\n        </Row>\n    </Container>\n</PageHead>';

var EXAMPLE_FILTERLIST = '<FilterList>\n    <FilterList.Item selected={true} count={21}>First filter</FilterList.Item>\n    <FilterList.Item count={3}>Second filter</FilterList.Item>\n    <FilterList.Item>Third filter</FilterList.Item>\n</FilterList>';

var EXAMPLE_PAGINATION = '<Pagination page={4} pages={20} pagesToList={3} />';

exports.default = function () {
    return React.createElement(
        Page,
        { title: 'Navigation', active: 'navigation' },
        React.createElement(
            Panel,
            null,
            React.createElement(Panel.Heading, { title: 'Navigation' }),
            React.createElement(
                Panel.Body,
                null,
                React.createElement(
                    'p',
                    null,
                    'This styleguide comes with several navigation components. Some were designed with singular purposes, while others were design to be more flexible and appear quite frequently.'
                ),
                React.createElement(CodeEditor, { source: EXAMPLE_IMPORTS })
            )
        ),
        React.createElement(Example, { title: 'Page head with menu', source: EXAMPLE_PAGEHEAD_MENU, scope: SCOPE }),
        React.createElement(Example, { title: 'Page head with search bar', source: EXAMPLE_PAGEHEAD_SEARCH, scope: SCOPE }),
        React.createElement(Example, { title: 'Page head with overview', source: EXAMPLE_PAGEHEAD_OVERVIEW, scope: SCOPE }),
        React.createElement(
            Example,
            { title: 'Menu', source: EXAMPLE_MENU, scope: SCOPE },
            'The menu is a vertical list of navigational links. It should be put in a panel.'
        ),
        React.createElement(
            Example,
            { title: 'Filter list', source: EXAMPLE_FILTERLIST, scope: SCOPE },
            'A vertical list of filters. Grey text on white background. Selecting a filter from the list will fill its background with blue and make the text white.'
        ),
        React.createElement(Example, { title: 'Pagination', source: EXAMPLE_PAGINATION, scope: SCOPE })
    );
};
//# sourceMappingURL=data:application/json;base64,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