'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
var React = require('react');

var Page = require('./components/Page');
var Example = require('./components/Example');
var CodeEditor = require('./components/CodeEditor');

var Panel = require('../src/Panel');
var Popover = require('../src/Popover');
var Input = require('../src/Input');
var Icon = require('../src/Icon');
var Button = require('../src/Button');

var SCOPE = { React: React, Panel: Panel, Popover: Popover, Button: Button, Input: Input, Icon: Icon };

var EXAMPLE_IMPORT = 'const Popover = require(\'gitbook-styleguide/lib/Popover\');';

var EXAMPLE_DEFAULT = '<Popover>\n    <Popover.Heading title="Hello" />\n    <Popover.Body>\n        Inner body of the popover.\n    </Popover.Body>\n    <Popover.Controls>\n        <Popover.Control active onClick={event => alert(\'Hello\')}>\n            Say Hello\n        </Popover.Control>\n        <Popover.Control onClick={event => alert(\'World\')}>\n            Say World\n        </Popover.Control>\n    </Popover.Controls>\n</Popover>';

var EXAMPLE_WITH_INPUT = '<Popover>\n    <Popover.Heading>\n        <Popover.Title>\n            <Icon id="pencil" /> Edit title\n        </Popover.Title>\n    </Popover.Heading>\n    <Popover.Body>\n        <Input placeholder="Some title" />\n    </Popover.Body>\n</Popover>';

var EXAMPLE_BUTTON = '<Popover.Container>\n    <Button onClick={event => this.setState({ open: !this.state.open })}>\n        Toggle Popover\n    </Button>\n    {this.state.open? (<Popover>\n        <Popover.Heading title="Hello" />\n        <Popover.Body>\n            Inner body of the popover.\n        </Popover.Body>\n    </Popover>) : null}\n</Popover.Container>';

exports.default = function () {
    return React.createElement(
        Page,
        { title: 'Popovers', active: 'popovers' },
        React.createElement(
            Panel,
            null,
            React.createElement(Panel.Heading, { title: 'Popovers' }),
            React.createElement(
                Panel.Body,
                null,
                React.createElement(
                    'p',
                    null,
                    'Add small overlay content, like those found in iOS, to any element for housing secondary information.'
                ),
                React.createElement(CodeEditor, { source: EXAMPLE_IMPORT })
            )
        ),
        React.createElement(Example, { title: 'Example', source: EXAMPLE_DEFAULT, scope: SCOPE }),
        React.createElement(Example, { title: 'With an input', source: EXAMPLE_WITH_INPUT, scope: SCOPE }),
        React.createElement(Example, { title: 'With button and state', source: EXAMPLE_BUTTON, scope: SCOPE })
    );
};
//# sourceMappingURL=data:application/json;base64,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