'use strict';

var React = require('react');
var classNames = require('classnames');

var SIZES = require('./SIZES');

var Modal = React.createClass({
    displayName: 'Modal',

    propTypes: {
        size: React.PropTypes.oneOf(SIZES),
        backdrop: React.PropTypes.bool,
        children: React.PropTypes.node,
        className: React.PropTypes.string
    },

    getDefaultProps: function getDefaultProps() {
        return {
            size: 'md',
            backdrop: true
        };
    },
    render: function render() {
        var className = classNames('modal', 'modal-' + this.props.size, this.props.className, {
            'without-backdrop': !this.props.backdrop
        });

        return React.createElement(
            'div',
            { className: className },
            this.props.children
        );
    }
});

var ModalBackdrop = React.createClass({
    displayName: 'ModalBackdrop',

    propTypes: {
        children: React.PropTypes.node
    },

    render: function render() {
        return React.createElement(
            'div',
            { className: 'modal-backdrop ' },
            this.props.children
        );
    }
});

var ModalBody = React.createClass({
    displayName: 'ModalBody',

    propTypes: {
        children: React.PropTypes.node
    },

    render: function render() {
        return React.createElement(
            'div',
            { className: 'modal-body' },
            this.props.children
        );
    }
});

var ModalFooter = React.createClass({
    displayName: 'ModalFooter',

    propTypes: {
        children: React.PropTypes.node
    },

    render: function render() {
        return React.createElement(
            'div',
            { className: 'modal-footer ' },
            this.props.children
        );
    }
});

var ModalHeading = React.createClass({
    displayName: 'ModalHeading',

    propTypes: {
        children: React.PropTypes.node,
        onClose: React.PropTypes.func,
        title: React.PropTypes.string
    },

    onClose: function onClose(e) {
        e.preventDefault();
        this.props.onClose();
    },
    render: function render() {
        if (this.props.title) {
            return React.createElement(
                'div',
                { className: 'modal-heading' },
                React.createElement(
                    'h4',
                    null,
                    this.props.title
                ),
                this.props.onClose ? React.createElement(
                    'a',
                    { href: '#', onClick: this.onClose, className: 'modal-close' },
                    '\xD7'
                ) : ''
            );
        }

        return React.createElement(
            'div',
            { className: 'modal-heading' },
            this.props.children
        );
    }
});

module.exports = Modal;
module.exports.Backdrop = ModalBackdrop;
module.exports.Body = ModalBody;
module.exports.Footer = ModalFooter;
module.exports.Heading = ModalHeading;
//# sourceMappingURL=data:application/json;base64,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