'use strict';

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

var React = require('react');
var classNames = require('classnames');

var Link = require('./Link');

var POSITIONS = ['bottom', 'top'];

/**
 * Pop content with controls over content:
 *
 * <Popover.Container>
 *   <Button>Open</Button>
 *   {open?
 *      <Popover>
 *         <Popover.Heading title="Hello" />
 *         <Popover.Body>...</Popover.Body>
 *         <Popover.Controls>
 *           <Popover.Control onClick={...}>Say Hello</Popover.Control>
 *           <Popover.Control onClick={...}>Say World</Popover.Control>
 *         </Popover.Controls>
 *      </Popover>
 *   : null}
 * </Popover.Container>
 */

var Popover = React.createClass({
    displayName: 'Popover',

    propTypes: {
        position: React.PropTypes.oneOf(POSITIONS),
        children: React.PropTypes.node
    },

    getDefaultProps: function getDefaultProps() {
        return {
            position: POSITIONS[0]
        };
    },
    render: function render() {
        var position = this.props.position;

        var className = classNames('popover', 'popover-' + position);

        return React.createElement(
            'div',
            { className: 'popover-wrapper' },
            React.createElement(
                'div',
                { className: className },
                React.createElement(
                    PopoverCard,
                    null,
                    React.createElement('div', { className: 'popover-arrow' }),
                    this.props.children
                )
            )
        );
    }
});

var PopoverContainer = React.createClass({
    displayName: 'PopoverContainer',

    propTypes: {
        children: React.PropTypes.node,
        className: React.PropTypes.string
    },

    render: function render() {
        var _props = this.props,
            className = _props.className,
            props = _objectWithoutProperties(_props, ['className']);

        className = classNames('popover-container', className);

        return React.createElement(
            'div',
            _extends({ className: className }, props),
            this.props.children
        );
    }
});

// The actual element that looks like a popup card.
var PopoverCard = React.createClass({
    displayName: 'PopoverCard',

    propTypes: {
        children: React.PropTypes.node
    },

    render: function render() {
        return React.createElement(
            'div',
            _extends({ className: 'popover-card' }, this.props),
            this.props.children
        );
    }
});

var PopoverBody = React.createClass({
    displayName: 'PopoverBody',

    propTypes: {
        children: React.PropTypes.node
    },

    render: function render() {
        return React.createElement(
            'div',
            { className: 'popover-body' },
            this.props.children
        );
    }
});

var PopoverTitle = React.createClass({
    displayName: 'PopoverTitle',

    propTypes: {
        children: React.PropTypes.node
    },

    render: function render() {
        return React.createElement(
            'div',
            { className: 'popover-title' },
            this.props.children
        );
    }
});

var PopoverHeading = React.createClass({
    displayName: 'PopoverHeading',

    propTypes: {
        title: React.PropTypes.string,
        children: React.PropTypes.node
    },

    render: function render() {
        var _props2 = this.props,
            title = _props2.title,
            children = _props2.children;


        if (title) {
            children = React.createElement(
                PopoverTitle,
                null,
                title
            );
        }

        return React.createElement(
            'div',
            { className: 'popover-heading' },
            children
        );
    }
});

var PopoverControl = React.createClass({
    displayName: 'PopoverControl',

    propTypes: {
        children: React.PropTypes.node,
        onClick: React.PropTypes.func,
        active: React.PropTypes.bool
    },

    render: function render() {
        var _props3 = this.props,
            onClick = _props3.onClick,
            children = _props3.children,
            active = _props3.active;

        var className = classNames('control', { active: active });

        return React.createElement(
            Link,
            { className: className, onClick: onClick },
            children
        );
    }
});

var PopoverControls = React.createClass({
    displayName: 'PopoverControls',

    propTypes: {
        children: React.PropTypes.node
    },

    render: function render() {
        return React.createElement(
            'div',
            { className: 'popover-controls' },
            this.props.children
        );
    }
});

module.exports = Popover;
module.exports.Card = PopoverCard;
module.exports.Body = PopoverBody;
module.exports.Heading = PopoverHeading;
module.exports.Title = PopoverTitle;
module.exports.Container = PopoverContainer;
module.exports.Control = PopoverControl;
module.exports.Controls = PopoverControls;
//# sourceMappingURL=data:application/json;base64,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