'use strict';

var React = require('react');
var classNames = require('classnames');

var Input = require('./Input');
var Spinner = require('./Spinner');

var KEYCODE_ENTER = 13;
var KEYCODE_UP = 38;
var KEYCODE_DOWN = 40;

var Autocomplete = React.createClass({
    displayName: 'Autocomplete',

    propTypes: {
        onFetch: React.PropTypes.func.isRequired,
        renderResult: React.PropTypes.func.isRequired,
        onChange: React.PropTypes.func.isRequired,
        // Called when onEnter on the input (no result selected)
        // query -> ()
        onEnter: React.PropTypes.func.isRequired,
        onPaste: React.PropTypes.func,
        value: React.PropTypes.string,
        placeholder: React.PropTypes.string,
        size: React.PropTypes.string
    },

    getInitialState: function getInitialState() {
        return {
            value: this.props.value || '',
            cursor: null,
            loading: false,
            focused: false,
            results: []
        };
    },


    /**
     * Typed value changed, we fetch the new autocomplete result
     */
    onInputChanged: function onInputChanged(e) {
        var that = this;
        var onFetch = this.props.onFetch;
        var value = e.target.value;

        this.setState({
            value: value,
            loading: true
        });

        onFetch(value, function (results) {
            that.setState({
                loading: false,
                results: results
            });
        });
    },


    /**
     * User is focusing/blur the input
     */
    onFocusChanged: function onFocusChanged(isFocused) {
        this.setState({
            focused: isFocused
        });
    },


    /**
     * Submit value at cursor
     */
    onEnter: function onEnter() {
        var _state = this.state,
            cursor = _state.cursor,
            value = _state.value;
        var onEnter = this.props.onEnter;

        if (cursor >= 0) {
            this.onSelect(cursor);
        } else if (onEnter) {
            onEnter(value);
            this.setState({
                focused: false,
                cursor: null,
                results: [],
                value: ''
            });
        }
    },


    /**
     * Submit a value
     */
    onSelect: function onSelect(index) {
        var onChange = this.props.onChange;
        var _state2 = this.state,
            value = _state2.value,
            results = _state2.results;

        var selected = results[index];

        this.setState({
            cursor: null,
            results: [],
            value: ''
        });

        onChange(value, selected);
    },


    /**
     * User pressed a key in text input
     */
    onKeyDown: function onKeyDown(e) {
        var _state3 = this.state,
            cursor = _state3.cursor,
            results = _state3.results;


        if (e.keyCode === KEYCODE_ENTER) {
            e.preventDefault();
            this.onEnter();
        } else if (e.keyCode === KEYCODE_DOWN) {
            e.preventDefault();
            cursor++;
        } else if (e.keyCode === KEYCODE_UP) {
            e.preventDefault();
            cursor--;
        }

        if (cursor >= results.length) {
            cursor = results.length - 1;
        }
        if (cursor < -1) {
            cursor = -1;
        }

        this.setState({
            cursor: cursor
        });
    },


    /**
     * Render the suggestions
     */
    renderResults: function renderResults() {
        var that = this;
        var _state4 = this.state,
            results = _state4.results,
            value = _state4.value,
            cursor = _state4.cursor;

        var ResultComponent = this.props.renderResult;

        return React.createElement(
            'div',
            { className: 'AutocompleteResults' },
            results.map(function (result, i) {
                var isActive = i === cursor;

                return React.createElement(
                    AutocompleteResult,
                    { key: value + '-' + i, active: isActive,
                        onClick: function onClick(e) {
                            return that.onSelect(i);
                        } },
                    React.createElement(ResultComponent, { result: result, index: i, active: isActive })
                );
            })
        );
    },
    render: function render() {
        var _this = this;

        var _props = this.props,
            onPaste = _props.onPaste,
            size = _props.size,
            placeholder = _props.placeholder;
        var _state5 = this.state,
            value = _state5.value,
            focused = _state5.focused,
            loading = _state5.loading,
            results = _state5.results;


        return React.createElement(
            'div',
            { className: 'Autocomplete' },
            React.createElement(Input, {
                value: value,
                placeholder: placeholder,
                size: size,
                onChange: this.onInputChanged,
                onFocus: function onFocus(e) {
                    return _this.onFocusChanged(true);
                },
                onBlur: function onBlur(e) {
                    return _this.onFocusChanged(false);
                },
                onPaste: onPaste,
                onKeyDown: this.onKeyDown
            }),
            loading ? React.createElement(Spinner, { size: 'sm', centered: false }) : '',
            focused && results.length > 0 ? this.renderResults() : ''
        );
    }
});

var AutocompleteResult = React.createClass({
    displayName: 'AutocompleteResult',

    propTypes: {
        active: React.PropTypes.bool,
        onClick: React.PropTypes.func,
        children: React.PropTypes.node
    },

    render: function render() {
        var _props2 = this.props,
            active = _props2.active,
            children = _props2.children,
            onClick = _props2.onClick;

        return React.createElement(
            'div',
            { className: classNames('AutocompleteResult', { active: active }),
                onMouseDown: onClick },
            children
        );
    }
});

module.exports = Autocomplete;
//# sourceMappingURL=data:application/json;base64,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